/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vf;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.vf.ApexClassPropertyTypes;
import net.sourceforge.pmd.lang.vf.DataType;
import net.sourceforge.pmd.lang.vf.ObjectFieldTypes;
import net.sourceforge.pmd.lang.vf.VfParserOptions;
import net.sourceforge.pmd.lang.vf.ast.ASTAttribute;
import net.sourceforge.pmd.lang.vf.ast.ASTAttributeValue;
import net.sourceforge.pmd.lang.vf.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.vf.ast.ASTElExpression;
import net.sourceforge.pmd.lang.vf.ast.ASTElement;
import net.sourceforge.pmd.lang.vf.ast.ASTExpression;
import net.sourceforge.pmd.lang.vf.ast.ASTText;
import net.sourceforge.pmd.lang.vf.ast.VfAstInternals;
import net.sourceforge.pmd.lang.vf.ast.VfParserVisitorAdapter;
import net.sourceforge.pmd.lang.vf.ast.VfTypedNode;
import org.apache.commons.lang3.StringUtils;

class VfExpressionTypeVisitor
extends VfParserVisitorAdapter {
    private static final Logger LOGGER = Logger.getLogger(VfExpressionTypeVisitor.class.getName());
    private static final String APEX_PAGE = "apex:page";
    private static final String CONTROLLER_ATTRIBUTE = "controller";
    private static final String STANDARD_CONTROLLER_ATTRIBUTE = "standardcontroller";
    private static final String EXTENSIONS_ATTRIBUTE = "extensions";
    private final ApexClassPropertyTypes apexClassPropertyTypes;
    private final ObjectFieldTypes objectFieldTypes;
    private final String fileName;
    private String standardControllerName;
    private final List<String> apexClassNames;
    private final List<String> apexDirectories;
    private final List<String> objectsDirectories;

    VfExpressionTypeVisitor(String fileName, VfParserOptions propertySource) {
        this.fileName = fileName;
        this.apexDirectories = (List)propertySource.getProperty(VfParserOptions.APEX_DIRECTORIES_DESCRIPTOR);
        this.objectsDirectories = (List)propertySource.getProperty(VfParserOptions.OBJECTS_DIRECTORIES_DESCRIPTOR);
        this.apexClassNames = new ArrayList<String>();
        this.apexClassPropertyTypes = new ApexClassPropertyTypes();
        this.objectFieldTypes = new ObjectFieldTypes();
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        if (StringUtils.isBlank((CharSequence)this.fileName)) {
            return data;
        }
        if (this.apexDirectories.isEmpty() && this.objectsDirectories.isEmpty()) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTElement node, Object data) {
        if (APEX_PAGE.equalsIgnoreCase(node.getName())) {
            List attribs = node.findChildrenOfType(ASTAttribute.class);
            for (ASTAttribute attr : attribs) {
                String lowerAttr = attr.getName().toLowerCase(Locale.ROOT);
                if (CONTROLLER_ATTRIBUTE.equals(lowerAttr)) {
                    this.apexClassNames.add(0, ((ASTText)((ASTAttributeValue)attr.getFirstChildOfType(ASTAttributeValue.class)).getFirstChildOfType(ASTText.class)).getImage());
                    break;
                }
                if (STANDARD_CONTROLLER_ATTRIBUTE.equals(lowerAttr)) {
                    this.standardControllerName = ((ASTText)((ASTAttributeValue)attr.getFirstChildOfType(ASTAttributeValue.class)).getFirstChildOfType(ASTText.class)).getImage().toLowerCase(Locale.ROOT);
                    continue;
                }
                if (!EXTENSIONS_ATTRIBUTE.equalsIgnoreCase(lowerAttr)) continue;
                for (String extension : ((ASTText)((ASTAttributeValue)attr.getFirstChildOfType(ASTAttributeValue.class)).getFirstChildOfType(ASTText.class)).getImage().split(",")) {
                    this.apexClassNames.add(extension.trim());
                }
            }
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTElExpression node, Object data) {
        for (Map.Entry<VfTypedNode, String> entry : this.getDataNodeNames(node).entrySet()) {
            String apexClassName;
            String fullName;
            String name = entry.getValue();
            DataType type = null;
            String[] parts = name.split("\\.");
            Iterator<String> iterator = this.apexClassNames.iterator();
            while (iterator.hasNext() && (type = this.apexClassPropertyTypes.getDataType(fullName = (apexClassName = iterator.next()) + "." + name, this.fileName, this.apexDirectories)) == null) {
            }
            if (type == null && parts.length >= 2 && this.standardControllerName != null && this.standardControllerName.equalsIgnoreCase(parts[0])) {
                type = this.objectFieldTypes.getDataType(name, this.fileName, this.objectsDirectories);
            }
            if (type != null) {
                VfAstInternals.setDataType(entry.getKey(), type);
                continue;
            }
            LOGGER.fine("Unable to determine type for: " + name);
        }
        return super.visit(node, data);
    }

    private IdentityHashMap<VfTypedNode, String> getDataNodeNames(ASTElExpression node) {
        IdentityHashMap<VfTypedNode, String> dataNodeToName = new IdentityHashMap<VfTypedNode, String>();
        for (ASTExpression expression : node.findChildrenOfType(ASTExpression.class)) {
            try {
                dataNodeToName.putAll(expression.getDataNodes());
            }
            catch (ASTExpression.DataNodeStateException ignore) {}
        }
        return dataNodeToName;
    }
}

