/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.dfa;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.DataFlowHandler;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.dfa.DataFlowNode;
import net.sourceforge.pmd.lang.dfa.NodeType;
import net.sourceforge.pmd.lang.dfa.StackObject;
import net.sourceforge.pmd.lang.dfa.StartOrEndDataFlowNode;

@Deprecated
public class Structure {
    private static final Logger LOGGER = Logger.getLogger(Structure.class.getName());
    private final DataFlowHandler dataFlowHandler;
    private List<DataFlowNode> dataFlow = new ArrayList<DataFlowNode>();
    private Stack<StackObject> braceStack = new Stack();
    private Stack<StackObject> continueBreakReturnStack = new Stack();

    public Structure(DataFlowHandler dataFlowHandler) {
        this.dataFlowHandler = dataFlowHandler;
    }

    public DataFlowNode createNewNode(Node node) {
        return this.dataFlowHandler.createDataFlowNode(this.dataFlow, node);
    }

    public DataFlowNode createStartNode(int line) {
        return new StartOrEndDataFlowNode(this.dataFlow, line, true);
    }

    public DataFlowNode createEndNode(int line) {
        return new StartOrEndDataFlowNode(this.dataFlow, line, false);
    }

    public DataFlowNode getLast() {
        return this.dataFlow.get(this.dataFlow.size() - 1);
    }

    public DataFlowNode getFirst() {
        return this.dataFlow.get(0);
    }

    public void pushOnStack(NodeType type, DataFlowNode node) {
        StackObject obj = new StackObject(type, node);
        if (type == NodeType.RETURN_STATEMENT || type == NodeType.BREAK_STATEMENT || type == NodeType.CONTINUE_STATEMENT || type == NodeType.THROW_STATEMENT) {
            this.continueBreakReturnStack.push(obj);
            this.tryToLog("continueBreakReturnStack", node);
        } else {
            this.braceStack.push(obj);
            this.tryToLog("braceStack", node);
        }
        node.setType(type);
    }

    protected void tryToLog(String tag, DataFlowNode node) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(tag + ": line" + node.getNode().getBeginLine() + ", column " + node.getNode().getBeginColumn() + " - " + node.toString());
        }
    }

    public List<StackObject> getBraceStack() {
        return this.braceStack;
    }

    public List<StackObject> getContinueBreakReturnStack() {
        return this.continueBreakReturnStack;
    }

    public String dump() {
        StringBuilder stringDump = new StringBuilder(120).append("Data Flow Analysis Structure:\n").append("    Edge Nodes (ContinueBraceReturn) :");
        for (StackObject stackObject : this.continueBreakReturnStack) {
            stringDump.append("\nCBR => ").append(stackObject.toString());
        }
        stringDump.append("\n    Scope Nodes:");
        for (StackObject stackObject : this.braceStack) {
            stringDump.append("\nBraces => ").append(stackObject.toString());
        }
        return stringDump.toString();
    }
}

