/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.common.base.Result;
import apex.common.base.VoidResult;
import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierOrAnnotation;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;

public final class VisibleApiVersionUtil {
    public static Result<Void> checkApiVisible(AccessEvaluator accessEvaluator, TypeInfo referencingType, String memberName, ModifierGroup targetModifiers, Member.Type type) {
        int maxApi;
        Version maxApiVersion;
        int minApi;
        Version minApiVersion;
        ModifierOrAnnotation annotation = targetModifiers.get(AnnotationTypeInfos.VISIBLE_API_VERSION);
        if (annotation == null) {
            return VoidResult.of();
        }
        Version version = referencingType.getCodeUnitDetails().getVersion();
        if (VisibleApiVersionUtil.skipVersionCheck(accessEvaluator, referencingType)) {
            return VoidResult.of();
        }
        AnnotationParameter minApiParameter = annotation.getParameter("minApiVersion");
        if (minApiParameter != null && version.isLessThan(minApiVersion = Version.fromInternal(minApi = minApiParameter.getIntegerValue().intValue()))) {
            return Result.error(I18nSupport.getLabel("not.visible.min.version", type.getNameForMessage(), memberName, Double.toString(minApiVersion.getExternal())));
        }
        AnnotationParameter maxApiParameter = annotation.getParameter("maxApiVersion");
        if (maxApiParameter != null && version.isGreaterThan(maxApiVersion = Version.fromInternal(maxApi = maxApiParameter.getIntegerValue().intValue()))) {
            return Result.error(I18nSupport.getLabel("not.visible.max.version", type.getNameForMessage(), memberName, Double.toString(maxApiVersion.getExternal())));
        }
        return VoidResult.of();
    }

    private static boolean skipVersionCheck(AccessEvaluator accessEvaluator, TypeInfo referencingType) {
        return referencingType.getCodeUnitDetails().isFileBased() || accessEvaluator.isAccessibleSystemNamespace(referencingType.getNamespace()) || accessEvaluator.isSfdc() || accessEvaluator.hasInternalSfdc();
    }
}

