/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data;

import apex.common.collect.MoreIterables;
import apex.common.tuple.IntPair;
import apex.common.tuple.IntPairInterner;
import apex.jorje.data.Identifier;
import apex.jorje.data.IndexLocation;
import apex.jorje.data.Location;
import apex.jorje.data.LocationBlocks;
import apex.jorje.data.PositionLocation;
import apex.jorje.data.ast.AnnotationValue;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.IfBlock;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.WhenCase;
import apex.jorje.data.errors.LexicalError;
import apex.jorje.data.errors.SyntaxError;
import apex.jorje.data.errors.UserError;
import apex.jorje.data.soql.FieldIdentifier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.util.List;

public final class Locations {
    public static final Location NONE = new PositionLocation(-1, -1);
    public static final Location ANONYMOUS_BLOCK = new PositionLocation(1, 1);
    public static final IntPair EXTERNAL = IntPair.tuple(-1, -1);
    private static Factory FACTORY = PositionFactory.access$000();

    private Locations() {
    }

    @VisibleForTesting
    public static void useIndexFactory() {
        FACTORY = IndexFactory.get();
    }

    public static Location loc(int line, int column) {
        return Locations.loc(0, 0, line, column);
    }

    public static Location index(int index, int length) {
        return Locations.loc(index, index + length, 1, index + 1);
    }

    public static Location from(Location startLoc, Location endLoc) {
        if (startLoc == NONE) {
            return endLoc;
        }
        if (endLoc == NONE) {
            return startLoc;
        }
        int startLine = startLoc.getLine();
        int startColumn = startLoc.getColumn();
        int startIndex = startLoc.getStartIndex();
        int endIndex = endLoc.getEndIndex();
        return Locations.loc(startIndex, endIndex, startLine, startColumn);
    }

    public static Location loc(int startIndex, int endIndex, int line, int column) {
        return FACTORY.loc(startIndex, endIndex, line, column);
    }

    public static Location from(Stmnt stmnt) {
        return stmnt == null ? NONE : stmnt.match(LocationBlocks.STATEMENT_LOC);
    }

    static Location from(IfBlock ifBlock) {
        return ifBlock == null ? NONE : ifBlock.loc;
    }

    public static Location from(Expr expr) {
        return expr == null ? NONE : expr.match(LocationBlocks.EXPRESSION_LOC);
    }

    public static Location from(TypeRef typeRef) {
        return typeRef == null ? NONE : typeRef.accept(LocationBlocks.TYPE_REF_LOC);
    }

    public static Location from(CompilationUnit unit) {
        return unit == null ? NONE : unit.match(LocationBlocks.COMPILATION_UNIT_LOC);
    }

    public static Location from(Identifier name) {
        return name == null ? NONE : name.getLoc();
    }

    public static Location from(List<Identifier> names) {
        return names == null ? NONE : Locations.from(Locations.from(MoreIterables.getFirst(names, null)), Locations.from(Iterables.getLast(names, null)));
    }

    public static Location from(LexicalError error) {
        return error.match(LocationBlocks.LEXICAL_ERROR_LOC);
    }

    public static Location from(SyntaxError error) {
        return error.match(LocationBlocks.SYNTAX_ERROR_LOC);
    }

    public static Location from(AnnotationValue value) {
        return value == null ? NONE : value.match(LocationBlocks.ANNOTATION_VALUE_LOC);
    }

    public static Location from(FieldIdentifier identifier) {
        return identifier == null ? NONE : Locations.from(identifier.field);
    }

    public static boolean lessThanOrEqual(Location left, Location right) {
        if (left == NONE || right == NONE) {
            return true;
        }
        return left.getLine() < right.getLine() || left.getLine() == right.getLine() && left.getColumn() < right.getColumn() || left.getLine() == right.getLine() && left.getColumn() == right.getColumn();
    }

    public static boolean lessThan(Location left, Location right) {
        if (left == NONE || right == NONE) {
            return true;
        }
        return left.getLine() < right.getLine() || left.getLine() == right.getLine() && left.getColumn() < right.getColumn();
    }

    public static Location from(UserError error) {
        return error.match(LocationBlocks.USER_ERROR_LOC);
    }

    public static boolean isReal(Location loc) {
        return loc != NONE;
    }

    public static IntPair toPair(Location loc) {
        return loc == NONE || loc == null ? EXTERNAL : IntPair.tuple(loc.getLine(), loc.getColumn());
    }

    public static Location from(WhenCase whenCase) {
        return whenCase == null ? NONE : whenCase.match(LocationBlocks.WHEN_CASE_LOC);
    }

    private static final class PositionFactory
    implements Factory {
        private static final IntPairInterner<Location> INTERNER = new IntPairInterner<Location>(PositionLocation::new);
        private static final PositionFactory INSTANCE = new PositionFactory();

        private PositionFactory() {
        }

        private static PositionFactory get() {
            return INSTANCE;
        }

        @Override
        public Location loc(int startIndex, int endIndex, int line, int column) {
            assert (startIndex > -1) : "negative start index provided";
            assert (endIndex > -1) : "negative end index provided";
            assert (line > -1) : "negative line provided";
            assert (column > -1) : "negative column provided";
            return INTERNER.intern(line, column);
        }

        static /* synthetic */ PositionFactory access$000() {
            return PositionFactory.get();
        }
    }

    private static final class IndexFactory
    implements Factory {
        private static final IndexFactory INSTANCE = new IndexFactory();

        private IndexFactory() {
        }

        private static IndexFactory get() {
            return INSTANCE;
        }

        @Override
        public Location loc(int startIndex, int endIndex, int line, int column) {
            assert (startIndex > -1) : "negative start index provided";
            assert (endIndex > -1) : "negative end index provided";
            assert (line > -1) : "negative line provided";
            assert (column > -1) : "negative column provided";
            return new IndexLocation(startIndex, endIndex, line, column);
        }
    }

    private static interface Factory {
        public Location loc(int var1, int var2, int var3, int var4);
    }
}

