/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Value;

public final class CastableExpression
extends UnaryExpression {
    AtomicType targetType;
    boolean allowEmpty;

    public CastableExpression(Expression source, AtomicType target, boolean allowEmpty) {
        super(source);
        this.targetType = target;
        this.allowEmpty = allowEmpty;
    }

    public AtomicType getTargetType() {
        return this.targetType;
    }

    public boolean allowsEmpty() {
        return this.allowEmpty;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand = visitor.simplify(this.operand);
        return this.preEvaluate(visitor);
    }

    private Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        if (Literal.isAtomic(this.operand)) {
            return Literal.makeLiteral(BooleanValue.get(this.effectiveBooleanValue(visitor.getStaticContext().makeEarlyEvaluationContext())));
        }
        if (Literal.isEmptySequence(this.operand)) {
            return new Literal(BooleanValue.get(this.allowEmpty));
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (!CastExpression.isPossibleCast(this.operand.getItemType(th).getAtomizedItemType().getPrimitiveType(), this.targetType.getPrimitiveType())) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        return this.preEvaluate(visitor);
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.optimize(this.operand, contextItemType);
        return this.preEvaluate(visitor);
    }

    public boolean equals(Object other) {
        return super.equals(other) && this.targetType == ((CastableExpression)other).targetType && this.allowEmpty == ((CastableExpression)other).allowEmpty;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public int computeCardinality() {
        return 16384;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public Expression copy() {
        return new CastableExpression(this.getBaseExpression().copy(), this.targetType, this.allowEmpty);
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        Item item;
        int count = 0;
        SequenceIterator iter = this.operand.iterate(context);
        while ((item = iter.next()) != null) {
            if (item instanceof NodeInfo) {
                AtomicValue av;
                Value atomizedValue = ((NodeInfo)item).atomize();
                int length = atomizedValue.getLength();
                if ((count += length) > 1) {
                    return false;
                }
                if (length == 0 || CastableExpression.isCastable(av = (AtomicValue)atomizedValue.itemAt(0), this.targetType, context)) continue;
                return false;
            }
            AtomicValue av = (AtomicValue)item;
            if (++count > 1) {
                return false;
            }
            if (CastableExpression.isCastable(av, this.targetType, context)) continue;
            return false;
        }
        return count != 0 || this.allowEmpty;
    }

    public static boolean isCastable(AtomicValue value, AtomicType targetType, XPathContext context) {
        return !(value.convert(targetType, true, context) instanceof ValidationFailure);
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("castable");
        out.emitAttribute("as", this.targetType.toString(out.getConfiguration().getNamePool()));
        this.operand.explain(out);
        out.endElement();
    }
}

