/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.symboltable;

import net.sourceforge.pmd.lang.plsql.ast.ASTExpression;
import net.sourceforge.pmd.lang.plsql.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class PLSQLNameOccurrence
implements NameOccurrence {
    private PLSQLNode location;
    private String image;
    private PLSQLNameOccurrence qualifiedName;
    private boolean isMethodOrConstructorInvocation;
    private int argumentCount;
    private static final String THIS = "this";
    private static final String SUPER = "super";

    public PLSQLNameOccurrence(PLSQLNode location, String image) {
        this.location = location;
        this.image = image;
    }

    public void setIsMethodOrConstructorInvocation() {
        this.isMethodOrConstructorInvocation = true;
    }

    public void setArgumentCount(int count) {
        this.argumentCount = count;
    }

    public int getArgumentCount() {
        return this.argumentCount;
    }

    public boolean isMethodOrConstructorInvocation() {
        return this.isMethodOrConstructorInvocation;
    }

    public void setNameWhichThisQualifies(PLSQLNameOccurrence qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public PLSQLNameOccurrence getNameForWhichThisIsAQualifier() {
        return this.qualifiedName;
    }

    public boolean isPartOfQualifiedName() {
        return this.qualifiedName != null;
    }

    public PLSQLNode getLocation() {
        return this.location;
    }

    public boolean isOnRightHandSide() {
        PLSQLNode node = this.location.getParent().getParent().getParent();
        return node instanceof ASTExpression && node.getNumChildren() == 3;
    }

    public boolean isOnLeftHandSide() {
        PLSQLNode primaryExpression;
        if (this.location.getParent() instanceof ASTPrimaryExpression) {
            primaryExpression = this.location.getParent().getParent();
        } else if (this.location.getParent().getParent() instanceof ASTPrimaryExpression) {
            primaryExpression = this.location.getParent().getParent().getParent();
        } else {
            throw new RuntimeException("Found a NameOccurrence that didn't have an ASTPrimaryExpression as parent or grandparent.  Node = " + this.location.getClass().getCanonicalName() + ", Parent = " + this.location.getParent().getClass().getCanonicalName() + " and grandparent = " + this.location.getParent().getParent().getClass().getCanonicalName() + " @ line = " + this.location.getBeginLine() + ", column = " + this.location.getBeginColumn());
        }
        if (primaryExpression.getNumChildren() <= 1) {
            return false;
        }
        return !this.isPartOfQualifiedName();
    }

    public boolean isThisOrSuper() {
        return this.image.equals(THIS) || this.image.equals(SUPER);
    }

    public boolean equals(Object o) {
        if (o instanceof PLSQLNameOccurrence) {
            PLSQLNameOccurrence n = (PLSQLNameOccurrence)o;
            return n.getImage().equals(this.getImage());
        }
        return false;
    }

    public int hashCode() {
        return this.getImage().hashCode();
    }

    public String getImage() {
        return this.image;
    }

    public String toString() {
        return this.getImage() + ":" + this.location.getBeginLine() + ":" + this.location.getClass() + (this.isMethodOrConstructorInvocation() ? "(method call)" : "");
    }
}

