/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import apex.common.collect.CaseInsensitiveMap;
import apex.common.collect.LinkedCaseInsensitiveMap;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;

public final class MoreMaps {
    private static final Class<?> UNMODIFIABLE_MAP = Collections.unmodifiableMap(Collections.emptyMap()).getClass();

    private MoreMaps() {
    }

    public static boolean isImmutableMap(Map<?, ?> map) {
        return map != null && (map instanceof ImmutableMap || map == Collections.emptyMap() || map.getClass() == UNMODIFIABLE_MAP);
    }

    public static <K, V> Map<K, V> toImmutableMap(Map<K, V> map) {
        if (MoreMaps.isImmutableMap(map)) {
            return map;
        }
        return MoreMaps.isNullOrEmpty(map) ? Collections.emptyMap() : Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> toEmptyMap(Map<K, V> map) {
        return MoreMaps.isNullOrEmpty(map) ? Collections.emptyMap() : map;
    }

    public static <K, V> boolean isNullOrEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static <V> Map<String, V> newCaseInsensitiveMap() {
        return new CaseInsensitiveMap();
    }

    public static <V> Map<String, V> newCaseInsensitiveMap(int initialSize) {
        return new CaseInsensitiveMap(initialSize);
    }

    public static <V> Map<String, V> toImmutableCaseInsensitiveMap(Map<String, V> input) {
        if (MoreMaps.isNullOrEmpty(input)) {
            return ImmutableMap.of();
        }
        Map<String, V> caseInsensitiveMap = MoreMaps.newCaseInsensitiveMap(input.size());
        caseInsensitiveMap.putAll(input);
        return Collections.unmodifiableMap(caseInsensitiveMap);
    }

    public static <V> Map<String, V> newLinkedCaseInsensitiveMap() {
        return new LinkedCaseInsensitiveMap();
    }
}

