/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data;

import apex.jorje.data.Identifier;
import apex.jorje.data.Identifiers;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.AnnotationParameter;
import apex.jorje.data.ast.AnnotationValue;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.Modifier;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public final class JadtFactory {
    public static final List<Identifier> LIST = Identifiers.newIdentifiers("List");
    public static final List<Identifier> SET = Identifiers.newIdentifiers("Set");
    public static final List<Identifier> MAP = Identifiers.newIdentifiers("Map");
    public static final String REQUEST = "Request";

    private JadtFactory() {
    }

    public static Expr.VariableExpr variableExpr(Optional<Expr> dottedExpr, Identifier identifier) {
        return new Expr.VariableExpr(dottedExpr, false, ImmutableList.of(identifier));
    }

    public static Modifier.Annotation annotationKeyValues(String name) {
        return new Modifier.Annotation(Locations.NONE, Identifiers.newIdentifier(name), ImmutableList.of());
    }

    public static Modifier.Annotation annotationKeyValues(String name, String ... keyValues) {
        assert (keyValues.length % 2 == 0) : "illegal key value pair list";
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int i = 0; i < keyValues.length; i += 2) {
            String key = keyValues[i];
            String value = keyValues[i + 1];
            parameters.add(AnnotationParameter._AnnotationKeyValue(Locations.NONE, Identifiers.newIdentifier(key), AnnotationValue._StringAnnotationValue(Locations.NONE, value)));
        }
        return new Modifier.Annotation(Locations.NONE, Identifiers.newIdentifier(name), (List<AnnotationParameter>)((Object)parameters.build()));
    }

    public static Modifier.Annotation annotationWithString(String name, String value) {
        assert (value != null);
        return new Modifier.Annotation(Locations.NONE, Identifiers.newIdentifier(name), ImmutableList.of(AnnotationParameter._AnnotationString(Locations.NONE, value)));
    }

    public static Modifier.Annotation annotation(String name) {
        return new Modifier.Annotation(Locations.NONE, Identifiers.newIdentifier(name), ImmutableList.of());
    }
}

