/*
 * Decompiled with CFR 0.152.
 */
package apex.common.collect;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class SinglePrependCollection<T>
extends AbstractCollection<T> {
    private final T head;
    private final Collection<? extends T> tail;

    SinglePrependCollection(T head, Collection<? extends T> tail) {
        this.head = head;
        this.tail = tail;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<? extends T> tailIterator = this.tail.iterator();
        return new Iterator<T>(){
            private boolean visitedHead;

            @Override
            public boolean hasNext() {
                return !this.visitedHead || tailIterator.hasNext();
            }

            @Override
            public T next() {
                if (!this.visitedHead) {
                    this.visitedHead = true;
                    return SinglePrependCollection.this.head;
                }
                if (tailIterator.hasNext()) {
                    return tailIterator.next();
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public int size() {
        return 1 + this.tail.size();
    }
}

