@page CHANGES-UNRELEASED Unreleased changes

This page contains changes that will end up in 2.5

Changes from version 2.4 which are relevant for users:
- Changes leading to incompatible behavior:
  - \ref RMSD, \ref PATHMSD, \ref PROPERTYMAP, \ref PCAVARS, \ref PCARMSD, \ref FIT_TO_TEMPLATE and \ref DIPOLE now automatically make molecules whole.
    In case you do not want them to do it, use NOPBC flag,

- New actions:
  - \ref PAMM
  - \ref HBPAMM_MATRIX
  - \ref HBPAMM_SH

- Changes in the eABF/DRR module (contributed by Haochuan Chen and Haohao Fu):
  - \ref DRR now supports the extended generalized ABF(egABF) method.
  - \ref DRR accepts different GRID options for CVs and extended variables.
  - The MAXFACTOR option is added in \ref DRR to control the factor of biasing force.
  - \ref drr_tool can calculate the divergence of gradients now. (Maybe useful for future pABF)
  - Fix conflicts of output files in multiple replicas.

- Other changes:
  - \ref EXTERNAL can now SCALE the input grid. This allows for more flexibility without modifying the grid file.
  - \ref ALPHABETA can now combine dihedrals with different coefficients
  - \ref CS2BACKBONE (isdb module) is now mpi parallelised in particular with DOSCORE and CAMSHIFT 
  - Libmatheval is not used anymore. \ref MATHEVAL (and \ref CUSTOM) are still available
    but employ an internal implementation of the lepton library. There should be no observable difference
    except from the fact that lepton does not support some of the inverse and hyperbolic functions supported
    by matheval (easily writable as a function of the available ones).

Changes from version 2.4 which are relevant for developers:
- Code has been cleanup up replacing a number of pointers with `std::unique_ptr`.
  (WORK IN PROGRESS: in principle we could aim at eliminating all delete statements)
- Exceptions cannot be disabled (`--disable-cxx-exceptions` option has been removed from `./configure`.
- Every exception thrown in PLUMED now also writes its message on PLUMED log.
- On OSX, `libplumed.dylib` links to `libplumedKernel.dylib` and `plumed` links to `libplumed.dylib`.
- On OSX, `./configure` uses `clang++` as first choice among non-MPI compilers.
- Added `--enable-static-archive` to `./configure` to build a `libplumed.a` static library.
- Stop setting `DYLD_LIBRARY_PATH` in `sourceme.sh` and in modulefile. Notice that as of PLUMED v2.3.3
  it should not be needed.

