@page CHANGES-2-8 Version 2.8
  
## Version 2.8 (under development)

This page contains changes that will end up in 2.8

- Changes leading to differences with previous versions
  - in \ref METAD and \ref PBMETAD, Gaussians are now stretched rather than truncated, making the energy a continuous function
    of the collective variable. See \issue{420}.
  - \ref sum_hills is now aware of stretched Gaussians. This change also fixes a minor bug in the set of grid points
    where Gaussians were different from zero that is still present up to version 2.7.
  - it is possible to restart from a HILLS file produced with PLUMED < 2.8, but Gaussians will be reinterpreted as stretched
    and a warning will be written in the log file. This might lead to small numerical changes in bias potentials.
  - in \ref METAD if possible the root walker in WALKERS_MPI will set the folder from which reading the GRID/HILLS file upon restart
  - in \ref METAD work is not calculated by default anymore, if needed it can be obtained using CALC_WORK
  - in \ref METAD an error will be thrown if, when restarting from FILE, the file is not found

- New actions:
  - \ref GHBFIX to compute generalized hydrogen-bond fixes

- New contributed module:
  - A new SASA module by Andrea Arsiccio
     - \ref SASA_HASEL
     - \ref SASA_LCPO
  - A new S2 contact model module by Omar Valsson 
     - \ref S2CM

- Other improvements
  - in \ref METAD a new keyword NLIST has been added to use a neighbor list for bias evaluation, this should be faster than grids with many CVs
  - in \ref METAD there are more checks that a restart of WALKERS_MPI is working consistently among walkers
  - in \ref driver there is a flag `--restart` that can be used to enforce restart (similar to using \ref RESTART in the PLUMED input file).
  - Added configure option `--enable-cxx`. Can be used to select C++14 with `--enable-cxx=14`. Required to compile against libraries
    whose header files need C++14.
  - Code explicitly crashes when a string cannot be parsed correctly. This was true only in a limited number of cases until v2.7. See \issue{717}.

- Changes in the OPES module
  - new action \ref OPES_EXPANDED
  - various new actions of type \ref EXPANSION_CV to be used with \ref OPES_EXPANDED
  - new action \ref OPES_METAD_EXPLORE
  - new flag EXTRA_BIAS_ARG in \ref OPES_METAD, to sample custom target distributions

- Changes in the VES module
  - New localized basis functions: Wavelets (\ref BF_WAVELETS), Gaussians (\ref BF_GAUSSIANS), and cubic splines (\ref BF_CUBIC_B_SPLINES). In particular, symmetric wavelets (symlets) have shown the best performance and are recommended of the localized basis functions. Furthermore, symlets have been shown to perform better than delocalized Chebyshev and Legendre polynomials.  
  - New optimizer based on Adam (\ref OPT_ADAM). Still experimental, and restarting with it does not work yet. 
  - New optimizer based on classical Robbins Monro stochastic gradient descent (\ref OPT_ROBBINS_MONRO_SGD). Only included for reference and not recommended for usage in simulations. 
  - Fixed a bug in \ref VES_LINEAR_EXPANSION for multidimensional bias potential if one (or more) of the CVs is outside the range of the bias potential. Previously, there was a force acting on the CVs if this happened. Now, there is no biasing force acting on the CVs if one (or more) of the CVs is outside the bias potential range. 

- For developers:
  - The C++ interface now performs type checking (see https://github.com/plumed/plumed2/pull/653).
    This should require no change for MD codes that were calling PLUMED with correct arguments.
    Checks could be disabled at runtime with `export PLUMED_TYPESAFE_IGNORE=yes`.
  - Two new Fortran modules have been added. One of them provides explicit interfaces for the already available wrappers.
    With no change in calling code, just by including this module, one could perform runtime type/shape checking.
    In addition, a novel object oriented Fortran interface has been designed which allow to better manipulate
    PLUMED instances from Fortran.
    Both interfaces were written with a significant help from Balint Aradi.
  - The C interface (`plumed_cmd`) also performs type checking and allows overload-like syntax to pass
    additional size and shape information. This is obtained redefining `plumed_cmd` to a macro that calls the C++ interface,
    when using a C++ compiler, or using C11 `_Generic`, if the C compiler supports it.
    This feature is not supported if used a pre-C11 C compiler (pre-C++11 C++ compilers are ok instead).
  - `xxd` replaced by a awk script. This removed the build dependence on vim.
  - Lepton has been updated with OpenMM 7.6.0
  - Asmjit is now enabled by default on supported architectures.
  - Xdrfile library is now embedded and always available.
  - `--enable-rpath` now also includes the path where `libplumedKernel.so` is installed (see \issue{767}).
