@page CHANGES-UNRELEASED Unreleased changes 

This page contains changes that will end up in 2.7

Changes from version 2.6 which are relevant for users:

- Changes leading to differences with previous versions
  - The definition of the omega angle has been modified to adhere to the IUPAC standard (i.e. with the previous amino acid)

- New contributed modules:
  - A new Funnel module by Stefano Raniolo and Vittorio Limongelli 
     - \ref FUNNEL_PS 
     - \ref FUNNEL 
  - A new Infinite Switch Simulated Tempering in Force module by Glen Hocky
     - \ref FISST

- New actions:
  - \ref ENVIRONMENTSIMILARITY from Pablo Piaggi
  - \ref PROJECTION_ON_AXIS from
  - \ref FUNCPATHGENERAL from

- Improved features:
  - \ref MOLINFO action can now be used multiple times. Every action doing a search will use the latest
    appearance. See \issue{134}.
  - Neighbor lists are now OpenMP and MPI parallel so improving the scalability of all actions employing them  
- GROMACS:
  - When using `-hrex` flag, the neighbor lists are update automatically at every exchange step.
    This relaxes the requirements on the choice of `-replex` stride (see \issue{579}, thanks to Chang Junhan).

For developers:
- small fix in `Plumed.h` too avoid unique global symbols (see \issue{549})
- Added `cmd("readInputLines")` to allow reading input from a buffer with comments and continuation lines (see \issue{571}).
