@page CHANGES-2-6 Version 2.6
  
## Version 2.6 (Jan 27, 2020)

Changes from version 2.5 which are relevant for users:
- Changes leading to incompatible behavior:
  - PLUMED input file parsing is now case insensitive that is that all directives can be written using uppercase characters (compatible with former versions) as well as lowercase characters (not compatible) internally PLUMED still uses uppercase definitions
  - `plumed partial_tempering` now uses `gawk` instead of `awk`. You might need to install `gawk` for it to work correctly.

- Other changes:
  - Asmjit is now embedded into PLUMED. In order to enable it, it is sufficient to configure with `--enable-asmjit`. See \ref Lepton "this page".
  - Fixed grids so as to decrease memory footprint of derivatives (see \issue{465}).
  - Added option `--idlp4` to \ref driver to read DLPOLY4 HISTORY files (see \issue{478}, thanks to Alin Marin Elena).
  - Added atom selectors using mdtraj/MDAnalysis/VMD syntax, see \ref MOLINFO and \issue{448}.
  - \ref EEFSOLV is now faster in scalar and also mpi/openmp parallel
  - New shortcuts are available for selecting protein atoms: `@sidechain-#`, `@back-#`
  - VIM syntax highlight is now case insensitive. Notice that autocompletion still only works with upper case commands.

- New contributed modules:
  - A new Maze module by Jakub Rydzewski
     - \ref MAZE_LOSS
     - \ref MAZE_MEMETIC_SAMPLING
     - \ref MAZE_RANDOM_ACCELERATION_MD
     - \ref MAZE_RANDOM_WALK
     - \ref MAZE_SIMULATED_ANNEALING
     - \ref MAZE_STEERED_MD
     - \ref MAZE_OPTIMIZER_BIAS
  - A new ANN module by Wei Chen and Andrew Ferguson
     - \ref ANN

- New patches:
  - added support for AMBER PMEMD 18 (contributed by Viktor Drobot, see \issue{486}).

- Changes in the VES module
  - new \ref VES_DELTA_F bias.
  - ves_md_linearexpansion now outputs one-dimensional free energy projections of the potential energy landscape. 

- Changes in the DRR module
  - The MAXFACTOR option now is tunable for each CV in multidimensional cases.
  - Output .zcount file (the same as .czar.count) for compatibility with newer abf_integrate.
  - The citation of DRR module has been updated.

- Changes in the ISDB module
  - in \ref METAINFERENCE we removed the MC_STRIDE keyword
  - in \ref METAINFERENCE the bias value (metainference score) now includes the Jeffrey's prior (values are different, but forces are equal)
  - components were previously named using _ but now they abide to the standard is -
  - removed ADDEXP keywords for \ref JCOUPLING \ref NOE \ref PRE \ref RDC
  - \ref METAINFERENCE performs more check on the input and restart files to ensure a consistent setup
  - \ref SAXS is slightly faster and scales better, removed BESSEL options

- Python module:
  - Removed compatibility with Python 2.
  - Added capability to read and write pandas dataset from PLUMED files (see \issue{496}).

Changes from version 2.5 which are relevant for developers:
  - Components documentation is now enforced
  - `readdir_r` is deprecated and is thus not used by default (can be enabled with `./configure --enable-readdir-r`).

## Version 2.6.1 (Jul 8, 2020)

For users:
- Includes all fixes up to 2.5.5
- New patches:
  - added gromacs 2019.6 
  - added gromacs 2020.2 (experimental) 

For developers:
- Small fix to avoid unique global symbols (see \issue{549})

