@page CHANGES-2-3 Version 2.3

## Version 2.3 (Dec 12, 2016)

Version 2.3 contains several improvements with respect to 2.2. Users currently working with 2.2
should have a look at the section "Changes leading to incompatible behavior" below and
might need tiny adjustments in their input files.

Below you find a list of all the changes with respect to version 2.2.
Notice that version 2.3 includes already all the fixes in branch 2.2 up to 2.2.3 indicated in \ref CHANGES-2-2 .

Changes from version 2.2 which are relevant for users:
- Changes leading to incompatible behavior:
  - \ref COMMITTOR can now be used to define multiple basins, but the syntax has been changed
  - Syntax for \ref SPRINT and \ref DFSCLUSTERING has changed.
    We have separated the Actions that calculate the contact matrix from these actions.  These actions thus now take a contact
    matrix as input.  This means that we these actions can be used with contact matrices that measures whether or not a pair of atoms
    are hydrogen bonded.  For more details on this see \ref contactmatrix.  For clustering the output can now be passed to the actions
    \ref CLUSTER_PROPERTIES, \ref CLUSTER_DIAMETER, \ref CLUSTER_NATOMS, \ref OUTPUT_CLUSTER and \ref CLUSTER_DISTRIBUTION.  These
    provide various different kinds of information about the connected components found by clustering 
  - In \ref driver masses and charges are set by default to NaN.
    This makes it less likely to do mistakes trying to compute centers of mass or electrostatic-dependent variables
    when masses or charges were not set. To compute these variables from the driver you are now forced to use
    `--pdb` or `--mc`.
  - In rational switching functions, by default MM is twice NN. This is valid both in \ref switchingfunction with expanded
    syntax and when specifying MM on e.g. \ref COORDINATION
  - Patch script `plumed patch` now patches by default with `--shared`. This should make the procedure more robust (see \issue{186}).
  - Faster \ref GYRATION but new default behavior is not mass weighted
  - When using \ref HISTOGRAM you now output the accumulated grid using \ref DUMPGRID or \ref DUMPCUBE to get the free energy you use
    the method \ref CONVERT_TO_FES.  These changes allow one to use grids calculated within PLUMED in a work flow of tasks similarly to 
    the way that you can currently use Values.
  - The way that reweighting is performed is now different.  There are three separate actions \ref REWEIGHT_BIAS, \ref REWEIGHT_TEMP and
    \ref REWEIGHT_METAD.  These actions calculate the quantities that were calculated using the keywords REWEIGHT_BIAS and REWEIGHT_TEMP that
    used to appear in the old HISTOGRAM method.  Now those these methods can be used in any methods that calculate ensemble averages for
    example \ref HISTOGRAM and \ref AVERAGE
  - Manual is now build with locally compiled plumed
  - Removed CH3SHIFT
  - \ref CS2BACKBONE is now native in PLUMED removing the need to link ALMOST, small syntax differences
  - \ref CS2BACKBONE, \ref NOE, \ref RDC, removed the keyword ENSEMBLE: now ensemble averages can only be calculated using \ref ENSEMBLE
  - \ref RDC, syntax changes
  - It is not possible anymore to select modules using `modulename.on` and `modulename.off` files. Use `./configure --enable-modules` instead.
  - Removed IMD modules. In case someone is interested in restoring it, please contact the PLUMED developers.
- New actions:
  - \ref FIXEDATOM
  - \ref HBOND_MATRIX
  - \ref CLUSTER_PROPERTIES
  - \ref CLUSTER_DIAMETER
  - \ref CLUSTER_NATOMS
  - \ref OUTPUT_CLUSTER
  - \ref CLUSTER_DISTRIBUTION
  - \ref ROWSUMS
  - \ref COLUMNSUMS
  - \ref UPDATE_IF
  - \ref DUMPGRID
  - \ref DUMPCUBE
  - \ref CONVERT_TO_FES
  - \ref INTERPOLATE_GRID
  - \ref FIND_CONTOUR
  - \ref FIND_SPHERICAL_CONTOUR
  - \ref FIND_CONTOUR_SURFACE
  - \ref AVERAGE
  - \ref REWEIGHT_BIAS
  - \ref REWEIGHT_TEMP
  - \ref REWEIGHT_METAD
  - \ref PCA
  - \ref PRE
  - \ref STATS
  - \ref METAINFERENCE
  - \ref LOCALENSEMBLE
  - \ref FRET
  - \ref RESET_CELL
  - \ref JCOUPLING
  - \ref ERMSD
- New features in MD patches (require repatch):
  - Patch for amber 14 now passes charges with appropriate units (fixes \issue{165}). Notice that
    the patch is still backward compatible with older PLUMED version, but the charges will only be passed
    when using PLUMED 2.3 or later.
  - Patch for GROMACS 5.1 incorporates Hamiltonian replica exchange, see \ref hrex
  - Gromacs 2016, 5.1.x, 5.0.x, flush the plumed output files upon checkpointing
  - Added patch for Gromacs 2016.1
  - gromacs 5.1.x patch updated to 5.1.4
  - Removed the patch for Gromacs 4.6.x 
  - LAMMPS patch updated to support multiple walkers and report plumed bias to LAMMPS (thanks to Pablo Piaggi).
- New features for existing actions:
  - The SPECIES and SPECIESA keyword in MultiColvars can now take a multicolvar as input.  This allows one
    to calculate quantities such as the Q4 parameters for those atoms that have a coordination number greater
    than x.
  - Added MATHEVAL type in \ref switchingfunction
  - Added Q type native contacts in \ref switchingfunction (thanks to Jan Domanski).
  - \ref COMMITTOR can now be used to define multiple basins
  - The number of atoms admitted in \ref BRIDGE has been significantly increased, see \issue{185}.
  - \ref driver now allows --trajectory-stride to be set to zero when reading with --ixtc/--itrr. In this case, step number is read from the trajectory file.
  - \ref METAD and \ref PBMETAD can now be restarted from a GRID 
  - Added keywords TARGET and DAMPFACTOR in \ref METAD
  - When using \ref METAD with file-based multple walkers and parallel jobs (i.e. mpirun) extra suffix is not added (thanks to Marco De La Pierre).
  - \ref ENSEMBLE added keywords for weighted averages, and calculation of higher momenta
  - \ref MOLINFO now allows single atoms to be picked by name.
  - \ref FIT_TO_TEMPLATE now supports optimal alignment.
  - \ref CONSTANT added the possibility of storing more values as components with or without derivatives
  - \ref PUCKERING now supports 6 membered rings.
  - Extended checkpoint infrastracture, now \ref METAD and \ref PBMETAD will write GRIDS also on checkpoint step (only the GROMACS patch
    is currently using the checkpointing interface)
- Other features:
  - Added a plumed-config command line tool. Can be used to inspect configuration also when cross compiling.
  - Added a `--mpi` option to `plumed`, symmetric to `--no-mpi`. Currently, it has no effect (MPI is initialized by default when available).
  - PLUMED now generate a VIM syntax file, see \ref VimSyntax
  - The backward cycle is now parallelised in MPI/OpenMP in case many collective variables are used.
  - GSL library is now searched by default during `./configure`.
  - Tutorials have been (partially) updated to reflect some of the changes in the syntax
  - Parser now reports errors when passing numbers that cannot be parsed instead of silently replacing their default value. See \issue{104}.
  - More and more documentation
- Bug fixes:
- Fixed a bug in \ref PBMETAD that was preventing the writing of GRIDS if a hill was not added in that same step 

For developers:
- IMPORTANT: BIAS can now be BIASED as well, this changes can lead to some incompatibility: now the "bias" component is always defined automatically
  by the constructure as a componentWithDerivatives, derivatives are automaticcaly obtained by forces. The main change is that you don't have to define
  the bias component anymore in your constructor and that you can use setBias(value) to set the value of the bias component in calculate. 
- Added new strings for plumed cmd: setMDMassUnits, setMDChargeUnits, readInputLine, performCalcNoUpdate, update and doCheckPoint.
- Easier to add actions with multiple arguments
- New functions to access local quantities in domain decomposition
- Active modules to enable regtests are chosen using `plumed config`.
- A script is available to check if source code complies plumed standard. Notice that this script is run together with cppcheck on travis-ci.
- Cppcheck on travis-ci has been updated to 1.75. Several small issues triggering errors on 1.75 were fixed (e.g. structures passed by value
   are now passed by const ref) and false positives marked as such.
- Added coverage scan.

## Version 2.3.1 (Mar 31, 2017)

- Fix to FIT_TO_TEMPLATE as in 2.2.5. Notice that in 2.3.0 also the case with TYPE=OPTIMAL was affected. This is fixed now.
- small change in \ref CS2BACKBONE to symmetrise the ring current contribution with respect to ring rotations (also faster)
- fixed `plumed-config` that was not working.
- log file points to the `config.txt` files to allow users to check which features were available in that compiled version.
- `make clean` in root dir now also cleans `vim` subdirectory.
- Updated gromacs patch to version 2016.3 

For developers:
- Cppcheck on travis-ci has been updated to 1.77.
- Doxygen on travis-ci has been updated to 1.8.13

## Version 2.3.2 (Jun 12, 2017)

See branch \branch{v2.3} on git repository.

- Resolved problem with nan in \ref SMAC with SPECIESA and SPECIESB involving molecules that are the same
- PDB reader is now able to read files with dos newlines (see \issue{223}).
- Fixed bug in \ref CS2BACKBONE (v2.3.1) related to ring currents of HIS and TRP
- Fixed bug in if condition in \ref PCAVARS so that you can run with only one eigenvector defined in input 
- Fixed bug with timers in \ref sum_hills \issue{194}.
- Fixed bug when using \ref MOVINGRESTRAINT with periodic variables such as \ref TORSION \issue{225}.
- Fixed bug in \ref HBOND_MATRIX that used to apear when you used DONORS and ACCEPTORS with same numbers of atoms 
- Fixed bug in \ref DISTANCES that appears when using BETWEEN and link cells.
- Prevented users from causing segfaults by storing derivatives without LOWMEM flag.  In these cases PLUMED crashes with meaningful errors.
- Fixed bug in \ref HISTOGRAM that causes nans when using KERNEL=DISCRETE option
- Fixed a bug in the parser related to braces, see \issue{229}
- Fixed a bug that appeared when using \ref Q3, \ref Q4 and \ref Q6 with LOWEST or HIGHEST flag
- Fixed a bug that appears when you use \ref MFILTER_LESS as input to \ref COORDINATIONNUMBER with SPECIESA and SPECIESB flags
- Fixed a bug that was making flushing when gromacs checkpoints not functional (thanks to Summer Snow).
- Fixed a bug affecting \ref EXTENDED_LAGRANGIAN and \ref METAD with ADAPT=DIFF when using an argument
  with periodicity (min,max) such that min is different from -max.
  This does not affect normal \ref TORSION, but would affect \ref PUCKERING component phi
  with 6-membered rings. In addition, it would affect any variable that is created by the user with a periodicity
  domain not symmetric around zero. See \issue{235} (thanks to Summer Snow for reporting this bug).
- Fixed numerical issue leading to simulations stuck (LatticeReduction problem) with intel compiler and
  large simulation cells.
- Fixed a bug affecting \ref LOCAL_AVERAGE and outputting all multicolvars calculated by \ref Q6 with \ref DUMPMULTICOLVAR
- `plumed info --user-doc` and `plumed info --developer-doc` now fall back to online manual when local doc is not installed,
  see \issue{240}.

For developers:
- IMPORTANT: we started to enforce code formatting using astyle. Check the developer documentation to learn how to
  take care of not-yet-formatted branches.
- plumedcheck validation has been made stricter. All the checks are now described in the developer manual.
- New flag `--disable-libsearch` for `configure`, allowing an easier control of linked libraries when installing PLUMED
  with a package manager such as MacPorts.
- Added `--disable-static-patch` to `./configure` to disable tests related to static patching. It can be used
  when static patching is not needed to make sure a wrong c++ library is not linked by mistake.
- Using `install_name_tool` to fix the name of the installed library on OSX. Allows linking the PLUMED
  shared library without explicitly setting `DYLD_LIBRARY_PATH`.
- Added environment variable `PLUMED_ASYNC_SHARE` to enforce synchronous/asynchronous atom sharing (mostly for debug purpose).
- On travis-ci, using ccache to speedup builds.
- On travis-ci, added a regtest using Docker with gcc6 and MPI.
- On travis-ci, docs for unofficial or unsupported branches are set not to be indexed by search engines (see \issue{239})
- Cppcheck on travis-ci has been updated to 1.79.

## Version 2.3.3 (Oct 3, 2017)

For users:
- Fixed a bug in \ref switchingfunction MATHEVAL, leading to inconsistent results when using OpenMP with multiple threads (see \issue{249}).
- \ref FIT_TO_TEMPLATE now reports when it is used with a reference file with zero weights.
- Fixed logging of \ref UNITS (thanks to Omar Valsson).
- Fixed a possible bug with \ref EFFECTIVE_ENERGY_DRIFT and domain decomposition with a domain containing zero atoms.


For developers:
- Fixed a bug in `./configure --disable-libsearch` when searching for molfile plugins.
- Cppcheck on travis-ci has been updated to 1.80.
- Configure script now has a list of better alternatives to find a working `ld -r -o` tool to merge object files.
  This solves linking issues on some peculiar systems (see \issue{291}, thanks to Massimiliano Culpo). 
- Using `install_name_tool` also on non-installed libraries. This makes it possible to link them and later
  find them without explicitly setting `DYLD_LIBRARY_PATH`. This should also make the `DYLD_LIBRARY_PATH` irrelevant.
  Notice that `DYLD_LIBRARY_PATH` is not well behaved in OSX El Capitan.

## Version 2.3.4 (Dec 15, 2017)

For users:
- GROMACS patch updated to gromacs-2016.4. This patch was also fixed in order to properly work with \ref ENERGY (see \issue{316})
  and to implement `-hrex` option (see \issue{197}).
- Patch for GROMACS 5.1.4 updated to fix an error with \ref ENERGY (see \issue{316}).
- Solved a bug in \ref ERMSD leading to incorrect results when using non-default length units (e.g. with `UNITS LENGTH=A`).

For developers:
- Regtest script also reports when exitcode different from zero is returned.
- Patch script reports errors returning a nonzero exit code.
- cppcheck update to 1.81
- Solved small bug in stored PLUMED_ROOT directory as obtained from statically patched MD codes.
  Namely, the compilation directory was stored rather than the installation one.

## Version 2.3.5 (Mar 2, 2018)

For users:
- Fixed `plumed partial_tempering` to agree with GROMACS conventions for the choice of dihedrals (see \issue{337}).
  Should be irrelevant for the vast majority of cases.
- Fixed small bug in regexp parser - the part outside the parentheses was just ignored.

For developers:
- Doxygen on travis-ci has been updated to 1.8.14.
- Embedded astyle updated to 3.1.
- `make clean` now correctly removes the `src/lib/plumed` executable.

## Version 2.3.6 (Jul 2, 2018)

For users:
- Fixed a problem leading to NaN derivatives of \ref switchingfunction `Q` when distance between two atoms is large.
- GROMACS patch updated to gromacs-2016.5.
- `./configure` crashes if prefix is set to present working directory (notice that this choice was already leading to issues).
- \ref DUMPATOMS reports an error when trying to write xtc/xdr files without the xdrfile library installed.
- Fixed a bug appearing when using \ref PATH or \ref GPROPERTYMAP with virtual atoms without simultaneously using the same
  atoms in a different action.
- Fixed incorrect format of the pdb file written by \ref PCA (see \issue{363}).
- Fixed behavior of natural units. When an MD code asks for natural units, it is not necessary to also set units within PLUMED using \ref UNITS (see \issue{364}).

For developers:
- Fixed small issue in debug options of \ref driver (see \issue{245}).
- `plumed patch -e` now accepts a name closely matching the patch name (e.g. `plumed patch -e gromacs2016.5` will try to patch
  even if the stored patch is for `gromacs-2016.4`). This simplifies managing Portfiles. Nothing changes when picking the patch
  from the interactive menu.
- Install newer ccache on travis-ci, build faster.
- Small fix in provided env modules (`PLUMED_VIMPATH` is set also when shared libraries are disabled).

## Version 2.3.7 (Oct 5, 2018)

\plumednotmaintained

For users:
- Fixed flag DETAILED_TIMERS in \ref DEBUG (flag was ignored and detailed timers always written).
- Small fix in \ref DUMPMASSCHARGE (atoms are now correctly requested only at first step).

