/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.apache.commons.javaflow.bytecode.transformation.ResourceTransformer;
import org.apache.commons.javaflow.bytecode.transformation.asm.AsmClassTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RewritingUtils {
    private static final Log log = LogFactory.getLog(RewritingUtils.class);
    private static final Matcher MATCH_ALL = new Matcher(){

        @Override
        public boolean isMatching(String pName) {
            return true;
        }
    };

    public static void rewriteClassFile(File pInput, ResourceTransformer transformer, File pOutput) throws IOException {
        byte[] original = RewritingUtils.toByteArray(pInput);
        byte[] transformed = transformer.transform(original);
        FileOutputStream os = new FileOutputStream(pOutput);
        os.write(transformed);
        os.close();
    }

    public static boolean rewriteJar(JarInputStream pInput, ResourceTransformer transformer, JarOutputStream pOutput) throws IOException {
        return RewritingUtils.rewriteJar(pInput, transformer, pOutput, MATCH_ALL);
    }

    public static boolean rewriteJar(JarInputStream pInput, ResourceTransformer transformer, JarOutputStream pOutput, Matcher pMatcher) throws IOException {
        JarEntry entry;
        boolean changed = false;
        while ((entry = pInput.getNextJarEntry()) != null) {
            if (entry.isDirectory()) {
                pOutput.putNextEntry(new JarEntry(entry));
                continue;
            }
            String name = entry.getName();
            pOutput.putNextEntry(new JarEntry(name));
            if (name.endsWith(".class")) {
                if (pMatcher.isMatching(name)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("transforming " + name));
                    }
                    byte[] original = RewritingUtils.toByteArray(pInput);
                    byte[] transformed = transformer.transform(original);
                    pOutput.write(transformed);
                    changed |= transformed.length != original.length;
                    continue;
                }
            } else if (name.endsWith(".jar") || name.endsWith(".ear") || name.endsWith(".zip") || name.endsWith(".war")) {
                changed |= RewritingUtils.rewriteJar(new JarInputStream(pInput), transformer, new JarOutputStream(pOutput), pMatcher);
                continue;
            }
            int length = RewritingUtils.copy(pInput, pOutput);
            log.debug((Object)("copied " + name + "(" + length + ")"));
        }
        pInput.close();
        pOutput.close();
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        try {
            byte[] byArray = RewritingUtils.toByteArray(in);
            return byArray;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RewritingUtils.copy(in, baos);
        return baos.toByteArray();
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] buf = new byte[8192];
        int total = 0;
        while ((n = in.read(buf)) >= 0) {
            out.write(buf, 0, n);
            total += n;
        }
        return total;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        AsmClassTransformer transformer = new AsmClassTransformer();
        for (int i = 0; i < args.length; i += 2) {
            RewritingUtils.rewriteJar(new JarInputStream(new FileInputStream(args[i])), transformer, new JarOutputStream(new FileOutputStream(args[i + 1])));
        }
    }

    public static interface Matcher {
        public boolean isMatching(String var1);
    }
}

