/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.nl.captcha;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import jj.play.ns.nl.captcha.backgrounds.BackgroundProducer;
import jj.play.ns.nl.captcha.backgrounds.TransparentBackgroundProducer;
import jj.play.ns.nl.captcha.gimpy.GimpyRenderer;
import jj.play.ns.nl.captcha.noise.NoiseProducer;
import jj.play.ns.nl.captcha.text.producer.TextProducer;
import jj.play.ns.nl.captcha.text.renderer.DefaultWordRenderer;

public class CaptchaBean {
    private BackgroundProducer _bgProd = new TransparentBackgroundProducer();
    private TextProducer _txtProd;
    private NoiseProducer _noiseProd;
    private GimpyRenderer _gimpy;
    private boolean _addBorder = false;
    private String _answer = "";
    private BufferedImage _img;
    private BufferedImage _bg;

    public CaptchaBean(int n, int n2) {
        this._img = new BufferedImage(n, n2, 2);
    }

    public CaptchaBean build() {
        Object object;
        if (this._txtProd != null) {
            this._answer = this._answer + this._txtProd.getText();
            object = new DefaultWordRenderer();
            object.render(this._answer, this._img);
        }
        if (this._noiseProd != null) {
            this._noiseProd.makeNoise(this._img);
        }
        if (this._gimpy != null) {
            this._gimpy.gimp(this._img);
        }
        this._bg = this._bgProd.getBackground(this._img.getWidth(), this._img.getHeight());
        object = this._bg.createGraphics();
        ((Graphics2D)object).setComposite(AlphaComposite.getInstance(3, 1.0f));
        ((Graphics2D)object).drawImage(this._img, null, null);
        if (this._addBorder) {
            int n = this._img.getWidth();
            int n2 = this._img.getHeight();
            ((Graphics)object).setColor(Color.BLACK);
            ((Graphics)object).drawLine(0, 0, 0, n);
            ((Graphics)object).drawLine(0, 0, n, 0);
            ((Graphics)object).drawLine(0, n2 - 1, n, n2 - 1);
            ((Graphics)object).drawLine(n - 1, n2 - 1, n - 1, 0);
        }
        this._img = this._bg;
        ((Graphics)object).dispose();
        return this;
    }

    public boolean isCorrect(String string) {
        return string.equals(this._answer);
    }

    public BufferedImage getImage() {
        return this._img;
    }

    public BackgroundProducer getBgProd() {
        return this._bgProd;
    }

    public void setBgProd(BackgroundProducer backgroundProducer) {
        this._bgProd = backgroundProducer;
    }

    public TextProducer getTxtProd() {
        return this._txtProd;
    }

    public void setTxtProd(TextProducer textProducer) {
        this._txtProd = textProducer;
    }

    public NoiseProducer getNoiseProd() {
        return this._noiseProd;
    }

    public void setNoiseProd(NoiseProducer noiseProducer) {
        this._noiseProd = noiseProducer;
    }

    public GimpyRenderer getGimpy() {
        return this._gimpy;
    }

    public void setGimpy(GimpyRenderer gimpyRenderer) {
        this._gimpy = gimpyRenderer;
    }

    public boolean isAddBorder() {
        return this._addBorder;
    }

    public void setAddBorder(boolean bl) {
        this._addBorder = bl;
    }

    public String getAnswer() {
        return this._answer;
    }

    public void setAnswer(String string) {
        this._answer = string;
    }
}

