/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.nl.captcha;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import jj.play.ns.nl.captcha.backgrounds.BackgroundProducer;
import jj.play.ns.nl.captcha.backgrounds.TransparentBackgroundProducer;
import jj.play.ns.nl.captcha.gimpy.GimpyRenderer;
import jj.play.ns.nl.captcha.gimpy.RippleGimpyRenderer;
import jj.play.ns.nl.captcha.noise.CurvedLineNoiseProducer;
import jj.play.ns.nl.captcha.noise.NoiseProducer;
import jj.play.ns.nl.captcha.text.producer.DefaultTextProducer;
import jj.play.ns.nl.captcha.text.producer.TextProducer;
import jj.play.ns.nl.captcha.text.renderer.DefaultWordRenderer;
import jj.play.ns.nl.captcha.text.renderer.WordRenderer;

public final class Captcha
implements Serializable {
    private static final long serialVersionUID = 617511236L;
    public static final String NAME = "simpleCaptcha";
    private Builder _builder;

    private Captcha(Builder builder) {
        this._builder = builder;
    }

    public boolean isCorrect(String string) {
        return this._builder._answer.equals(string);
    }

    public String getAnswer() {
        return this._builder._answer;
    }

    public BufferedImage getImage() {
        return this._builder._img;
    }

    public String toString() {
        return this._builder.toString();
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String _answer = "";
        private BufferedImage _img;
        private BufferedImage _bg;
        private boolean _addBorder = false;

        public Builder(int n, int n2) {
            this._img = new BufferedImage(n, n2, 2);
        }

        public Builder addBackground() {
            return this.addBackground(new TransparentBackgroundProducer());
        }

        public Builder addBackground(BackgroundProducer backgroundProducer) {
            this._bg = backgroundProducer.getBackground(this._img.getWidth(), this._img.getHeight());
            return this;
        }

        public Builder addText() {
            return this.addText(new DefaultTextProducer());
        }

        public Builder addText(TextProducer textProducer) {
            return this.addText(textProducer, new DefaultWordRenderer());
        }

        public Builder addText(WordRenderer wordRenderer) {
            return this.addText(new DefaultTextProducer(), wordRenderer);
        }

        public Builder addText(TextProducer textProducer, WordRenderer wordRenderer) {
            this._answer = this._answer + textProducer.getText();
            wordRenderer.render(this._answer, this._img);
            return this;
        }

        public Builder addNoise() {
            return this.addNoise(new CurvedLineNoiseProducer());
        }

        public Builder addNoise(NoiseProducer noiseProducer) {
            noiseProducer.makeNoise(this._img);
            return this;
        }

        public Builder gimp() {
            return this.gimp(new RippleGimpyRenderer());
        }

        public Builder gimp(GimpyRenderer gimpyRenderer) {
            gimpyRenderer.gimp(this._img);
            return this;
        }

        public Builder addBorder() {
            this._addBorder = true;
            return this;
        }

        public Captcha build() {
            if (this._bg == null) {
                this._bg = new TransparentBackgroundProducer().getBackground(this._img.getWidth(), this._img.getHeight());
            }
            Graphics2D graphics2D = this._bg.createGraphics();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D.drawImage(this._img, null, null);
            if (this._addBorder) {
                int n = this._img.getWidth();
                int n2 = this._img.getHeight();
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawLine(0, 0, 0, n);
                graphics2D.drawLine(0, 0, n, 0);
                graphics2D.drawLine(0, n2 - 1, n, n2 - 1);
                graphics2D.drawLine(n - 1, n2 - 1, n - 1, 0);
            }
            this._img = this._bg;
            return new Captcha(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[Answer: ");
            stringBuffer.append(this._answer);
            stringBuffer.append("][Image: ");
            stringBuffer.append(this._img);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this._answer);
            ImageIO.write((RenderedImage)this._img, "png", ImageIO.createImageOutputStream(objectOutputStream));
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this._answer = (String)objectInputStream.readObject();
            this._img = ImageIO.read(ImageIO.createImageInputStream(objectInputStream));
        }
    }
}

