/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.distributed;

import com.jamonapi.JamonPropertiesLoader;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorFactory;
import com.jamonapi.distributed.LocalJamonDataPersister;
import com.jamonapi.utils.FileUtils;
import com.jamonapi.utils.SerializationUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class LocalJamonFilePersister
extends LocalJamonDataPersister {
    private static final String FILE_EXT = ".ser";
    private JamonPropertiesLoader jamonPropertiesLoader = new JamonPropertiesLoader();
    private Map<String, String> fileNameMap = new HashMap<String, String>();
    static final String JAMON_FILE_NAME = "local-saved";

    @Override
    public Set<String> getInstances() {
        TreeSet<String> keys = new TreeSet<String>();
        keys.addAll(super.getInstances());
        File[] files = FileUtils.listFiles(this.getDirectoryName(), FILE_EXT);
        if (files == null || files.length == 0) {
            return keys;
        }
        keys.addAll(LocalJamonFilePersister.removeFileExtenstion(files));
        return keys;
    }

    @Override
    public void put() {
        this.put(JAMON_FILE_NAME);
    }

    @Override
    public void put(String instanceKey) {
        try {
            this.createDirectory();
            String fileName = this.getFileName(instanceKey);
            MonitorComposite monitorComposite = MonitorFactory.getRootMonitor().setInstanceName(instanceKey);
            SerializationUtils.serializeToFile(monitorComposite, fileName);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while trying to save jamondata", e);
        }
    }

    @Override
    public MonitorComposite get(String instanceKey) {
        try {
            MonitorComposite monitorComposite = super.get(instanceKey);
            if (monitorComposite != null) {
                return monitorComposite;
            }
            String fileName = this.getFileName(instanceKey);
            if (FileUtils.exists(fileName)) {
                monitorComposite = (MonitorComposite)SerializationUtils.deserializeFromFile(fileName);
                return monitorComposite;
            }
            return null;
        }
        catch (Throwable e) {
            throw new RuntimeException("Exception while trying to load jamondata", e);
        }
    }

    @Override
    public void remove(String instanceKey) {
        super.remove(instanceKey);
        String fileName = this.getFileName(instanceKey);
        if (FileUtils.exists(fileName)) {
            FileUtils.delete(fileName);
        }
    }

    private void createDirectory() {
        String dirName = this.getDirectoryName();
        if (!FileUtils.exists(dirName)) {
            FileUtils.mkdirs(dirName);
        }
    }

    protected String getDirectoryName() {
        String rootDir = this.jamonPropertiesLoader.getJamonProperties().getProperty("jamonDataPersister.directory");
        if (rootDir.endsWith(File.separator)) {
            return rootDir;
        }
        return rootDir + File.separator;
    }

    protected String getFileName(String key) {
        return this.getDirectoryName() + key + FILE_EXT;
    }

    static Set<String> removeFileExtenstion(File[] files) {
        TreeSet<String> keys = new TreeSet<String>();
        for (File file : files) {
            keys.add(file.getName().replace(FILE_EXT, ""));
        }
        return keys;
    }
}

