/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.playclipse.builder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ConfigurationFile {
    private IFile file;

    public ConfigurationFile(IProject project) {
        this.file = project.getFile("conf/application.conf");
    }

    public Map<String, String> getModules() {
        HashMap<String, String> result = new HashMap<String, String>();
        List<String> lines = this.getLines();
        Pattern p = Pattern.compile("module\\.(\\w+)=(.+)");
        for (String line : lines) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            String moduleName = m.group(1);
            String modulePath = m.group(2);
            result.put(moduleName, modulePath);
        }
        return null;
    }

    public int getPort() {
        List<String> lines = this.getLines();
        Pattern p = Pattern.compile("^\\s*port\\s*=([0-9]+)");
        for (String line : lines) {
            int port = 0;
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            String sport = m.group(1);
            try {
                port = Integer.parseInt(sport);
            }
            catch (NumberFormatException numberFormatException) {}
            if (port == 0) continue;
            return port;
        }
        return 9000;
    }

    private List<String> getLines() {
        InputStream is;
        ArrayList<String> result = new ArrayList<String>();
        try {
            is = this.file.getContents();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        try {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    result.add(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    is.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return null;
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

