/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.playclipse;

import fr.zenexity.pdt.editors.EditorHelper;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.playframework.playclipse.CodeTemplates;
import org.playframework.playclipse.FilesAccess;

public final class Navigation {
    private EditorHelper editorHelper;
    private IWorkbenchWindow window;
    private IProject project;
    private IJavaProject javaProject;

    public Navigation(EditorHelper editorHelper) {
        this.editorHelper = editorHelper;
        this.window = this.editorHelper.getWindow();
        this.project = this.editorHelper.getProject();
        this.javaProject = JavaCore.create((IProject)this.project);
    }

    private IType findType(String name) {
        try {
            IType type = this.javaProject.findType(name);
            System.out.println("Type for " + name + ": " + type);
            return type;
        }
        catch (CoreException e) {
            System.out.println((Object)e);
            e.printStackTrace();
            return null;
        }
    }

    public void goToAction(String action) {
        IFile file;
        String fullClassName = "controllers." + action.replaceFirst(".[^.]+$", "");
        System.out.println("goToAction for class: " + fullClassName);
        String method = action.substring(action.lastIndexOf(46) + 1);
        IType type = this.findType(fullClassName);
        try {
            file = (IFile)type.getCompilationUnit().getCorrespondingResource();
        }
        catch (JavaModelException e1) {
            e1.printStackTrace();
            return;
        }
        try {
            IEditorPart newEditorPart = FilesAccess.openFile(file, this.window);
            this.focusOrCreateMethod(newEditorPart, type, method);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void focusOrCreateMethod(IEditorPart editorPart, IType type, String methodName) throws JavaModelException {
        ISourceRange sourceRange = null;
        System.out.println("Looking for method: " + methodName);
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getElementName().equals(methodName)) {
                sourceRange = methods[i].getSourceRange();
            }
            ++i;
        }
        if (sourceRange != null) {
            FilesAccess.goToCharacter(editorPart, sourceRange.getOffset());
        } else if (MessageDialog.openConfirm((Shell)this.window.getShell(), (String)"Playclipse", (String)("The method " + methodName + " doesn't exist, do you want to create it?"))) {
            IMethod newMethod = type.createMethod("public static void " + methodName + "() {\n\n}\n", null, false, null);
            FilesAccess.goToCharacter(editorPart, newMethod.getSourceRange().getOffset());
        }
    }

    public void goToView(String viewName) {
        IFile file = this.project.getFile("app/views/" + viewName);
        if (!file.exists()) {
            IContainer cont = this.editorHelper.getFirstParentFor("views");
            file = this.project.getFile(cont.getProjectRelativePath() + "/" + viewName);
        }
        this.openOrCreate(file);
    }

    public void openOrCreate(String path) {
        IFile file = this.editorHelper.getProject().getFile(path);
        this.openOrCreate(file);
    }

    private void openOrCreate(IFile file) {
        if (file.exists()) {
            try {
                FilesAccess.openFile(file, this.window);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return;
        }
        String path = file.getFullPath().toString();
        if (MessageDialog.openConfirm((Shell)this.window.getShell(), (String)"Playclipse", (String)("The file " + path + " can't be found, do you want to create it?"))) {
            String[] titleArr = path.split("/");
            String title = titleArr[titleArr.length - 1].replace(".html", "");
            String content = CodeTemplates.view(title);
            FilesAccess.createAndOpen(file, content, FilesAccess.FileType.HTML);
        }
    }

    public static IProject getProject(IStructuredSelection selection) {
        Object obj = selection.getFirstElement();
        if (obj instanceof IJavaElement) {
            obj = ((IJavaElement)obj).getResource();
        }
        if (obj instanceof IResource) {
            IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
            while (container != null) {
                if (container instanceof IProject) {
                    return (IProject)container;
                }
                container = container.getParent();
            }
        }
        return null;
    }
}

