/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.NotEqualToField;
import net.sf.oval.context.OValContext;
import net.sf.oval.exception.FieldNotFoundException;
import net.sf.oval.exception.InvokingMethodFailedException;
import net.sf.oval.exception.MethodNotFoundException;
import net.sf.oval.internal.ContextCache;
import net.sf.oval.internal.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotEqualToFieldCheck
extends AbstractAnnotationCheck<NotEqualToField> {
    private static final long serialVersionUID = 1L;
    private boolean useGetter;
    private String fieldName;
    private Class<?> declaringClass;

    @Override
    public void configure(NotEqualToField constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setFieldName(constraintAnnotation.value());
        this.setDeclaringClass(constraintAnnotation.declaringClass());
        this.setUseGetter(constraintAnnotation.useGetter());
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("fieldName", this.fieldName);
        messageVariables.put("declaringClass", this.declaringClass == null || this.declaringClass == Void.class ? null : this.declaringClass.getName());
        messageVariables.put("useGetter", Boolean.toString(this.useGetter));
        return messageVariables;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        Object valueToCompare;
        if (valueToValidate == null) {
            return true;
        }
        Class<?> clazz = validatedObject.getClass();
        if (this.useGetter) {
            Method getter = ReflectionUtils.getGetterRecursive(clazz, this.fieldName);
            if (getter == null) {
                throw new MethodNotFoundException("Getter for field <" + this.fieldName + "> not found in class <" + clazz + "> or it's super classes.");
            }
            try {
                valueToCompare = getter.invoke(validatedObject, new Object[0]);
            }
            catch (Exception ex) {
                throw new InvokingMethodFailedException(getter.getName(), validatedObject, ContextCache.getMethodReturnValueContext(getter), ex);
            }
        } else {
            Field field = ReflectionUtils.getFieldRecursive(clazz, this.fieldName);
            if (field == null) {
                throw new FieldNotFoundException("Field <" + this.fieldName + "> not found in class <" + clazz + "> or it's super classes.");
            }
            valueToCompare = ReflectionUtils.getFieldValue(field, validatedObject);
        }
        if (valueToCompare == null) {
            return true;
        }
        return !valueToValidate.equals(valueToCompare);
    }

    public boolean isUseGetter() {
        return this.useGetter;
    }

    public void setDeclaringClass(Class<?> declaringClass) {
        this.declaringClass = declaringClass == Void.class ? null : declaringClass;
        this.requireMessageVariablesRecreation();
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
        this.requireMessageVariablesRecreation();
    }

    public void setUseGetter(boolean useGetter) {
        this.useGetter = useGetter;
        this.requireMessageVariablesRecreation();
    }
}

