/*
 * Decompiled with CFR 0.152.
 */
package jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.Textile;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.Attributes;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.TableAttributes;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.TableCellAttributes;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.TableRowAttributes;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class TableBlock
extends Block {
    static final Pattern startPattern = Pattern.compile("(table(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}\\.\\s*)|(\\|(.*)?(\\|\\s*$))");
    static final Pattern rowAttributesPattern = Pattern.compile("(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}\\.\\s*.*");
    static final Pattern TABLE_ROW_PATTERN = Pattern.compile("\\|(?:\\\\(\\d+))?(?:/(\\d+))?((?:\\<\\>)|\\<|\\>|\\^)?(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}(_|\\|)?\\.?\\s?([^\\|]*)(\\|\\|?\\s*$)?");
    private int blockLineCount = 0;
    private Matcher matcher;

    public int processLineContent(String line, int offset) {
        int start;
        Matcher rowAttributesMatcher;
        if (this.blockLineCount == 0) {
            TableAttributes attributes = new TableAttributes();
            if (this.matcher.group(1) != null) {
                Textile.configureAttributes((Attributes)attributes, this.matcher, 2, true);
                offset = line.length();
            }
            this.builder.beginBlock(DocumentBuilder.BlockType.TABLE, (Attributes)attributes);
        } else if (this.markupLanguage.isEmptyLine(line)) {
            this.setClosed(true);
            return 0;
        }
        ++this.blockLineCount;
        if (offset == line.length()) {
            return -1;
        }
        String textileLine = offset == 0 ? line : line.substring(offset);
        Matcher rowMatcher = TABLE_ROW_PATTERN.matcher(textileLine);
        if (!rowMatcher.find()) {
            this.setClosed(true);
            return 0;
        }
        TableRowAttributes rowAttributes = new TableRowAttributes();
        int rowStart = rowMatcher.start();
        if (rowStart > 0 && (rowAttributesMatcher = rowAttributesPattern.matcher(textileLine)).matches()) {
            Textile.configureAttributes((Attributes)rowAttributes, rowAttributesMatcher, 1, true);
        }
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, (Attributes)rowAttributes);
        while ((start = rowMatcher.start()) != textileLine.length() - 1) {
            String colSpan = rowMatcher.group(1);
            String rowSpan = rowMatcher.group(2);
            String alignment = rowMatcher.group(3);
            String headerIndicator = rowMatcher.group(8);
            String text = rowMatcher.group(9);
            int textLineOffset = rowMatcher.start(9);
            boolean header = headerIndicator != null && ("_".equals(headerIndicator) || "|".equals(headerIndicator));
            String textAlign = null;
            if (alignment != null) {
                if (alignment.equals("<>")) {
                    textAlign = "text-align: center;";
                } else if (alignment.equals(">")) {
                    textAlign = "text-align: right;";
                } else if (alignment.equals("<")) {
                    textAlign = "text-align: left;";
                } else if (alignment.equals("^")) {
                    textAlign = "text-align: top;";
                }
            }
            TableCellAttributes attributes = new TableCellAttributes();
            attributes.setCssStyle(textAlign);
            attributes.setRowspan(rowSpan);
            attributes.setColspan(colSpan);
            Textile.configureAttributes((Attributes)attributes, rowMatcher, 4, false);
            this.state.setLineCharacterOffset(start);
            this.builder.beginBlock(header ? DocumentBuilder.BlockType.TABLE_CELL_HEADER : DocumentBuilder.BlockType.TABLE_CELL_NORMAL, (Attributes)attributes);
            this.markupLanguage.emitMarkupLine(this.getParser(), this.state, textLineOffset, text, 0);
            this.builder.endBlock();
            if (rowMatcher.find()) continue;
        }
        this.builder.endBlock();
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

