/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import jj.play.ns.com.jhlabs.image.TransformFilter;

public class TwirlFilter
extends TransformFilter {
    static final long serialVersionUID = 1550445062822803342L;
    private double angle = 0.0;
    private double centreX = 0.0;
    private double centreY = 0.0;
    private double radius = 0.0;
    private double radius2 = 0.0;

    public void setAngle(double d) {
        this.angle = d;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setDimensions(int n, int n2) {
        super.setDimensions(n, n2);
        this.centreX = n / 2;
        this.centreY = n2 / 2;
        this.radius = Math.min(this.centreX, this.centreY);
        this.radius2 = this.radius * this.radius;
    }

    protected void transformInverse(int n, int n2, double[] dArray) {
        double d = (double)n - this.centreX;
        double d2 = (double)n2 - this.centreY;
        double d3 = d * d + d2 * d2;
        if (d3 > this.radius2) {
            dArray[0] = n;
            dArray[1] = n2;
        } else {
            d3 = Math.sqrt(d3);
            double d4 = Math.atan2(d2, d) + this.angle * (this.radius - d3) / this.radius;
            dArray[0] = this.centreX + d3 * Math.cos(d4);
            dArray[1] = this.centreY + d3 * Math.sin(d4);
        }
    }

    public String toString() {
        return "Distort/Twirl...";
    }
}

