/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.io.Serializable;
import java.util.Date;
import java.util.Random;
import jj.play.ns.com.jhlabs.image.Colormap;
import jj.play.ns.com.jhlabs.image.ImageMath;
import jj.play.ns.com.jhlabs.image.LinearColormap;
import jj.play.ns.com.jhlabs.image.WholeImageFilter;

public class SmearFilter
extends WholeImageFilter
implements Serializable {
    static final long serialVersionUID = 6491871753122667752L;
    public static final int CROSSES = 0;
    public static final int LINES = 1;
    public static final int CIRCLES = 2;
    public static final int SQUARES = 3;
    private Colormap colormap = new LinearColormap();
    private double angle = 0.0;
    private double density = 0.5;
    private double scatter = 0.0;
    private int distance = 8;
    private Random randomGenerator = new Random();
    private long seed = 567L;
    private int shape = 1;
    private double mix = 0.5;
    private int fadeout = 0;
    private boolean background = false;

    public void setShape(int n) {
        this.shape = n;
    }

    public int getShape() {
        return this.shape;
    }

    public void setDistance(int n) {
        this.distance = n;
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDensity(double d) {
        this.density = d;
    }

    public double getDensity() {
        return this.density;
    }

    public void setScatter(double d) {
        this.scatter = d;
    }

    public double getScatter() {
        return this.scatter;
    }

    public void setAngle(double d) {
        this.angle = d;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setMix(double d) {
        this.mix = d;
    }

    public double getMix() {
        return this.mix;
    }

    public void setFadeout(int n) {
        this.fadeout = n;
    }

    public int getFadeout() {
        return this.fadeout;
    }

    public void setBackground(boolean bl) {
        this.background = bl;
    }

    public boolean getBackground() {
        return this.background;
    }

    public void randomize() {
        this.seed = new Date().getTime();
    }

    private double random(double d, double d2) {
        return d + (d2 - d) * this.randomGenerator.nextDouble();
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        try {
            int n2;
            int n3 = this.originalSpace.width;
            int n4 = this.originalSpace.height;
            int[] nArray = new int[n3 * n4];
            this.randomGenerator.setSeed(this.seed);
            double d = Math.sin(this.angle);
            double d2 = Math.cos(this.angle);
            int n5 = 0;
            int n6 = 0;
            while (n6 < n4) {
                n2 = 0;
                while (n2 < n3) {
                    nArray[n5] = this.background ? -1 : this.inPixels[n5];
                    ++n5;
                    ++n2;
                }
                ++n6;
            }
            switch (this.shape) {
                case 0: {
                    int n7 = (int)(2.0 * this.density * (double)n3 * (double)n4 / (double)(this.distance + 1));
                    n5 = 0;
                    while (n5 < n7) {
                        int n8;
                        n2 = (this.randomGenerator.nextInt() & Integer.MAX_VALUE) % n3;
                        int n9 = (this.randomGenerator.nextInt() & Integer.MAX_VALUE) % n4;
                        int n10 = this.randomGenerator.nextInt() % this.distance + 1;
                        int n11 = this.inPixels[n9 * n3 + n2];
                        int n12 = n2 - n10;
                        while (n12 < n2 + n10 + 1) {
                            if (n12 >= 0 && n12 < n3) {
                                n8 = this.background ? -1 : nArray[n9 * n3 + n12];
                                nArray[n9 * n3 + n12] = ImageMath.mixColors(this.mix, n8, n11);
                            }
                            ++n12;
                        }
                        n8 = n9 - n10;
                        while (n8 < n9 + n10 + 1) {
                            if (n8 >= 0 && n8 < n4) {
                                int n13 = this.background ? -1 : nArray[n8 * n3 + n2];
                                nArray[n8 * n3 + n2] = ImageMath.mixColors(this.mix, n13, n11);
                            }
                            ++n8;
                        }
                        ++n5;
                    }
                    break;
                }
                case 1: {
                    int n14 = (int)(2.0 * this.density * (double)n3 * (double)n4 / 2.0);
                    n5 = 0;
                    while (n5 < n14) {
                        int n15;
                        int n16;
                        int n17;
                        int n18;
                        n2 = (this.randomGenerator.nextInt() & Integer.MAX_VALUE) % n3;
                        int n19 = (this.randomGenerator.nextInt() & Integer.MAX_VALUE) % n4;
                        int n20 = this.inPixels[n19 * n3 + n2];
                        int n21 = (this.randomGenerator.nextInt() & Integer.MAX_VALUE) % this.distance;
                        int n22 = (int)((double)n21 * d2);
                        int n23 = (int)((double)n21 * d);
                        int n24 = n2 - n22;
                        int n25 = n19 - n23;
                        int n26 = n2 + n22;
                        int n27 = n19 + n23;
                        int n28 = n26 < n24 ? -1 : 1;
                        int n29 = n27 < n25 ? -1 : 1;
                        n22 = n26 - n24;
                        n23 = n27 - n25;
                        n22 = Math.abs(n22);
                        n23 = Math.abs(n23);
                        int n30 = n24;
                        int n31 = n25;
                        if (n30 < n3 && n30 >= 0 && n31 < n4 && n31 >= 0) {
                            n18 = this.background ? -1 : nArray[n31 * n3 + n30];
                            nArray[n31 * n3 + n30] = ImageMath.mixColors(this.mix, n18, n20);
                        }
                        if (Math.abs(n22) > Math.abs(n23)) {
                            n17 = 2 * n23 - n22;
                            n16 = 2 * n23;
                            n15 = 2 * (n23 - n22);
                            while (n30 != n26) {
                                if (n17 <= 0) {
                                    n17 += n16;
                                } else {
                                    n17 += n15;
                                    n31 += n29;
                                }
                                if ((n30 += n28) >= n3 || n30 < 0 || n31 >= n4 || n31 < 0) continue;
                                n18 = this.background ? -1 : nArray[n31 * n3 + n30];
                                nArray[n31 * n3 + n30] = ImageMath.mixColors(this.mix, n18, n20);
                            }
                        } else {
                            n17 = 2 * n22 - n23;
                            n16 = 2 * n22;
                            n15 = 2 * (n22 - n23);
                            while (n31 != n27) {
                                if (n17 <= 0) {
                                    n17 += n16;
                                } else {
                                    n17 += n15;
                                    n30 += n28;
                                }
                                if (n30 >= n3 || n30 < 0 || (n31 += n29) >= n4 || n31 < 0) continue;
                                n18 = this.background ? -1 : nArray[n31 * n3 + n30];
                                nArray[n31 * n3 + n30] = ImageMath.mixColors(this.mix, n18, n20);
                            }
                        }
                        ++n5;
                    }
                    break;
                }
                case 2: 
                case 3: {
                    n2 = this.distance + 1;
                    int n32 = n2 * n2;
                    int n33 = (int)(2.0 * this.density * (double)n3 * (double)n4 / (double)n2);
                    n5 = 0;
                    while (n5 < n33) {
                        int n34 = (this.randomGenerator.nextInt() & Integer.MAX_VALUE) % n3;
                        int n35 = (this.randomGenerator.nextInt() & Integer.MAX_VALUE) % n4;
                        int n36 = this.inPixels[n35 * n3 + n34];
                        int n37 = n34 - n2;
                        while (n37 < n34 + n2 + 1) {
                            int n38 = n35 - n2;
                            while (n38 < n35 + n2 + 1) {
                                int n39 = this.shape == 2 ? (n37 - n34) * (n37 - n34) + (n38 - n35) * (n38 - n35) : 0;
                                if (n37 >= 0 && n37 < n3 && n38 >= 0 && n38 < n4 && n39 <= n32) {
                                    int n40 = this.background ? -1 : nArray[n38 * n3 + n37];
                                    nArray[n38 * n3 + n37] = ImageMath.mixColors(this.mix, n40, n36);
                                }
                                ++n38;
                            }
                            ++n37;
                        }
                        ++n5;
                    }
                    break;
                }
            }
            this.consumer.setPixels(0, 0, n3, n4, this.defaultRGBModel, nArray, 0, n3);
            this.consumer.imageComplete(n);
            this.inPixels = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String toString() {
        return "Effects/Smear...";
    }
}

