/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.io.Serializable;
import java.util.Date;
import java.util.Random;
import jj.play.ns.com.jhlabs.image.Colormap;
import jj.play.ns.com.jhlabs.image.LinearColormap;
import jj.play.ns.com.jhlabs.image.WholeImageFilter;

public class QuiltFilter
extends WholeImageFilter
implements Serializable {
    private Random randomGenerator;
    private long seed = 567L;
    private int iterations = 25000;
    private double a = -0.59;
    private double b = 0.2;
    private double c = 0.1;
    private double d = 0.0;
    private int k = 0;
    private Colormap colormap = new LinearColormap();

    public QuiltFilter() {
        this.randomGenerator = new Random();
    }

    public void randomize() {
        this.seed = new Date().getTime();
        this.randomGenerator.setSeed(this.seed);
        this.a = this.randomGenerator.nextDouble();
        this.b = this.randomGenerator.nextDouble();
        this.c = this.randomGenerator.nextDouble();
        this.d = this.randomGenerator.nextDouble();
        this.k = this.randomGenerator.nextInt() % 20 - 10;
    }

    public void setIterations(int n) {
        this.iterations = n;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setA(double d) {
        this.a = d;
    }

    public double getA() {
        return this.a;
    }

    public void setB(double d) {
        this.b = d;
    }

    public double getB() {
        return this.b;
    }

    public void setC(double d) {
        this.c = d;
    }

    public double getC() {
        return this.c;
    }

    public void setD(double d) {
        this.d = d;
    }

    public double getD() {
        return this.d;
    }

    public void setK(int n) {
        this.k = n;
    }

    public int getK() {
        return this.k;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int n2 = this.originalSpace.width;
        int n3 = this.originalSpace.height;
        int[] nArray = new int[n2 * n3];
        boolean bl = false;
        int n4 = 0;
        double d = 0.1;
        double d2 = 0.3;
        int n5 = 0;
        while (n5 < 20) {
            double d3 = Math.PI * d;
            double d4 = Math.PI * d2;
            double d5 = this.a * Math.sin(2.0 * d3) + this.b * Math.sin(2.0 * d3) * Math.cos(2.0 * d4) + this.c * Math.sin(4.0 * d3) + this.d * Math.sin(6.0 * d3) * Math.cos(4.0 * d4) + (double)this.k * d;
            d5 = d5 >= 0.0 ? d5 - (double)((int)d5) : d5 - (double)((int)d5) + 1.0;
            double d6 = this.a * Math.sin(2.0 * d4) + this.b * Math.sin(2.0 * d4) * Math.cos(2.0 * d3) + this.c * Math.sin(4.0 * d4) + this.d * Math.sin(6.0 * d4) * Math.cos(4.0 * d3) + (double)this.k * d2;
            d6 = d6 >= 0.0 ? d6 - (double)((int)d6) : d6 - (double)((int)d6) + 1.0;
            d = d5;
            d2 = d6;
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.iterations) {
            double d7 = Math.PI * d;
            double d8 = Math.PI * d2;
            double d9 = this.a * Math.sin(2.0 * d7) + this.b * Math.sin(2.0 * d7) * Math.cos(2.0 * d8) + this.c * Math.sin(4.0 * d7) + this.d * Math.sin(6.0 * d7) * Math.cos(4.0 * d8) + (double)this.k * d;
            d9 = d9 >= 0.0 ? d9 - (double)((int)d9) : d9 - (double)((int)d9) + 1.0;
            double d10 = this.a * Math.sin(2.0 * d8) + this.b * Math.sin(2.0 * d8) * Math.cos(2.0 * d7) + this.c * Math.sin(4.0 * d8) + this.d * Math.sin(6.0 * d8) * Math.cos(4.0 * d7) + (double)this.k * d2;
            d10 = d10 >= 0.0 ? d10 - (double)((int)d10) : d10 - (double)((int)d10) + 1.0;
            d = d9;
            d2 = d10;
            int n7 = (int)((double)n2 * d);
            int n8 = (int)((double)n3 * d2);
            if (n7 >= 0 && n7 < n2 && n8 >= 0 && n8 < n3) {
                int n9;
                int n10 = n2 * n8 + n7;
                nArray[n10] = nArray[n10] + 1;
                if (n9 > n4) {
                    n4 = n9;
                }
            }
            ++n6;
        }
        if (this.colormap != null) {
            int n11 = 0;
            d2 = 0.0;
            while (d2 < (double)n3) {
                d = 0.0;
                while (d < (double)n2) {
                    nArray[n11] = this.colormap.getColor((double)nArray[n11] / (double)n4);
                    ++n11;
                    d += 1.0;
                }
                d2 += 1.0;
            }
        }
        this.consumer.setPixels(0, 0, n2, n3, this.defaultRGBModel, nArray, 0, n2);
        this.consumer.imageComplete(n);
        this.inPixels = null;
    }

    public String toString() {
        return "Texture/Chaotic Quilt...";
    }
}

