/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.io.Serializable;
import java.util.Date;
import java.util.Random;
import jj.play.ns.com.jhlabs.image.Colormap;
import jj.play.ns.com.jhlabs.image.LinearColormap;
import jj.play.ns.com.jhlabs.image.PixelUtils;
import jj.play.ns.com.jhlabs.image.WholeImageFilter;

public class PlasmaFilter
extends WholeImageFilter
implements Serializable {
    static final long serialVersionUID = 6491871753122667752L;
    public double turbulence = 1.0;
    private double scaling = 0.0;
    private Colormap colormap = new LinearColormap();
    private Random randomGenerator = new Random();
    private long seed = 567L;
    private boolean useImageColors = false;

    public void setTurbulence(double d) {
        this.turbulence = d;
    }

    public double getTurbulence() {
        return this.turbulence;
    }

    public void setScaling(double d) {
        this.scaling = d;
    }

    public double getScaling() {
        return this.scaling;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setUseImageColors(boolean bl) {
        this.useImageColors = bl;
    }

    public boolean getUseImageColors() {
        return this.useImageColors;
    }

    public void randomize() {
        this.seed = new Date().getTime();
    }

    private int randomRGB(int n, int n2) {
        if (this.useImageColors) {
            return this.inPixels[n2 * this.originalSpace.width + n];
        }
        int n3 = (int)(255.0 * this.randomGenerator.nextDouble());
        int n4 = (int)(255.0 * this.randomGenerator.nextDouble());
        int n5 = (int)(255.0 * this.randomGenerator.nextDouble());
        return 0xFF000000 | n3 << 16 | n4 << 8 | n5;
    }

    private int displace(int n, double d) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        n2 = PixelUtils.clamp(n2 + (int)(d * (this.randomGenerator.nextDouble() - 0.5)));
        n3 = PixelUtils.clamp(n3 + (int)(d * (this.randomGenerator.nextDouble() - 0.5)));
        n4 = PixelUtils.clamp(n4 + (int)(d * (this.randomGenerator.nextDouble() - 0.5)));
        return 0xFF000000 | n2 << 16 | n3 << 8 | n4;
    }

    private int average(int n, int n2) {
        return PixelUtils.combinePixels(n, n2, 13);
    }

    private int getPixel(int n, int n2, int[] nArray, int n3) {
        return nArray[n2 * n3 + n];
    }

    private void putPixel(int n, int n2, int n3, int[] nArray, int n4) {
        nArray[n2 * n4 + n] = n3;
    }

    private boolean doPixel(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6, int n7) {
        if (n6 == 0) {
            int n8 = this.getPixel(n, n2, nArray, n5);
            int n9 = this.getPixel(n, n4, nArray, n5);
            int n10 = this.getPixel(n3, n2, nArray, n5);
            int n11 = this.getPixel(n3, n4, nArray, n5);
            double d = 256.0 / (2.0 * (double)n7) * this.turbulence;
            int n12 = (n + n3) / 2;
            int n13 = (n2 + n4) / 2;
            if (n12 == n && n12 == n3 && n13 == n2 && n13 == n4) {
                return true;
            }
            if (n12 != n || n12 != n3) {
                int n14 = this.average(n8, n9);
                n14 = this.displace(n14, d);
                this.putPixel(n, n13, n14, nArray, n5);
                if (n != n3) {
                    int n15 = this.average(n10, n11);
                    n15 = this.displace(n15, d);
                    this.putPixel(n3, n13, n15, nArray, n5);
                }
            }
            if (n13 != n2 || n13 != n4) {
                if (n != n12 || n13 != n4) {
                    int n16 = this.average(n9, n11);
                    n16 = this.displace(n16, d);
                    this.putPixel(n12, n4, n16, nArray, n5);
                }
                if (n2 != n4) {
                    int n17 = this.average(n8, n10);
                    n17 = this.displace(n17, d);
                    this.putPixel(n12, n2, n17, nArray, n5);
                }
            }
            if (n2 != n4 || n != n3) {
                int n18 = this.average(n8, n11);
                int n19 = this.average(n9, n10);
                n18 = this.average(n18, n19);
                n18 = this.displace(n18, d);
                this.putPixel(n12, n13, n18, nArray, n5);
            }
            return n3 - n >= 3 || n4 - n2 >= 3;
        }
        int n20 = (n + n3) / 2;
        int n21 = (n2 + n4) / 2;
        this.doPixel(n, n2, n20, n21, nArray, n5, n6 - 1, n7 + 1);
        this.doPixel(n, n21, n20, n4, nArray, n5, n6 - 1, n7 + 1);
        this.doPixel(n20, n2, n3, n21, nArray, n5, n6 - 1, n7 + 1);
        return this.doPixel(n20, n21, n3, n4, nArray, n5, n6 - 1, n7 + 1);
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int n2 = this.originalSpace.width;
        int n3 = this.originalSpace.height;
        int[] nArray = new int[n2 * n3];
        this.randomGenerator.setSeed(this.seed);
        int n4 = n2 - 1;
        int n5 = n3 - 1;
        this.putPixel(0, 0, this.randomRGB(0, 0), nArray, n2);
        this.putPixel(n4, 0, this.randomRGB(n4, 0), nArray, n2);
        this.putPixel(0, n5, this.randomRGB(0, n5), nArray, n2);
        this.putPixel(n4, n5, this.randomRGB(n4, n5), nArray, n2);
        this.putPixel(n4 / 2, n5 / 2, this.randomRGB(n4 / 2, n5 / 2), nArray, n2);
        this.putPixel(0, n5 / 2, this.randomRGB(0, n5 / 2), nArray, n2);
        this.putPixel(n4, n5 / 2, this.randomRGB(n4, n5 / 2), nArray, n2);
        this.putPixel(n4 / 2, 0, this.randomRGB(n4 / 2, 0), nArray, n2);
        this.putPixel(n4 / 2, n5, this.randomRGB(n4 / 2, n5), nArray, n2);
        int n6 = 1;
        while (this.doPixel(0, 0, n2 - 1, n3 - 1, nArray, n2, n6, 0)) {
            ++n6;
        }
        if (this.colormap != null) {
            int n7 = 0;
            int n8 = 0;
            while (n8 < n3) {
                int n9 = 0;
                while (n9 < n2) {
                    nArray[n7] = this.colormap.getColor((double)(nArray[n7] & 0xFF) / 255.0);
                    ++n7;
                    ++n9;
                }
                ++n8;
            }
        }
        this.consumer.setPixels(0, 0, n2, n3, this.defaultRGBModel, nArray, 0, n2);
        this.consumer.imageComplete(n);
        this.inPixels = null;
    }

    public String toString() {
        return "Texture/Plasma...";
    }
}

