/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.io.Serializable;
import jj.play.ns.com.jhlabs.image.Colormap;
import jj.play.ns.com.jhlabs.image.ImageMath;
import jj.play.ns.com.jhlabs.image.LinearColormap;
import jj.play.ns.com.jhlabs.image.PixelUtils;

public class GradientFilter
extends ImageFilter
implements Serializable {
    static final long serialVersionUID = 611926880411013769L;
    public static final int LINEAR = 0;
    public static final int BILINEAR = 1;
    public static final int RADIAL = 2;
    public static final int CONICAL = 3;
    public static final int BICONICAL = 4;
    public static final int SQUARE = 5;
    public static final int INT_LINEAR = 0;
    public static final int INT_CIRCLE_UP = 1;
    public static final int INT_CIRCLE_DOWN = 2;
    public static final int INT_SMOOTH = 3;
    private double angle = 0.0;
    private int color1 = -16777216;
    private int color2 = -1;
    private Point p1 = new Point(0, 0);
    private Point p2 = new Point(64, 64);
    private boolean repeat = false;
    private double x1;
    private double y1;
    private double dx;
    private double dy;
    private Colormap colormap = null;
    private int type;
    private int interpolation = 0;
    private int paintMode = 1;

    public GradientFilter() {
    }

    public GradientFilter(Point point, Point point2, int n, int n2, boolean bl, int n3, int n4) {
        this.p1 = point;
        this.p2 = point2;
        this.color1 = n;
        this.color2 = n2;
        this.repeat = bl;
        this.type = n3;
        this.interpolation = n4;
        this.colormap = new LinearColormap(n, n2);
    }

    public void setPoint1(Point point) {
        this.p1 = point;
    }

    public Point getPoint1() {
        return this.p1;
    }

    public void setPoint2(Point point) {
        this.p2 = point;
    }

    public Point getPoint2() {
        return this.p2;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setInterpolation(int n) {
        this.interpolation = n;
    }

    public int getInterpolation() {
        return this.interpolation;
    }

    public void setAngle(double d) {
        this.angle = d;
        this.p2 = new Point((int)(64.0 * Math.cos(d)), (int)(64.0 * Math.sin(d)));
    }

    public double getAngle() {
        return this.angle;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setPaintMode(int n) {
        this.paintMode = n;
    }

    public int getPaintMode() {
        return this.paintMode;
    }

    private void initialize() {
        double d;
        double d2;
        double d3 = this.p1.x;
        double d4 = this.p2.x;
        if (d3 > d4 && this.type != 2) {
            d2 = d3;
            d3 = d4;
            d4 = d2;
            d2 = this.p2.y;
            d = this.p1.y;
            int n = this.color2;
            int n2 = this.color1;
        } else {
            d2 = this.p1.y;
            d = this.p2.y;
            int n = this.color1;
            int n3 = this.color2;
        }
        double d5 = d4 - d3;
        double d6 = d - d2;
        double d7 = d5 * d5 + d6 * d6;
        this.x1 = d3;
        this.y1 = d2;
        if (d7 >= Double.MIN_VALUE) {
            d5 /= d7;
            d6 /= d7;
            if (this.repeat) {
                d5 %= 1.0;
                d6 %= 1.0;
            }
        }
        this.dx = d5;
        this.dy = d6;
    }

    public void setDimensions(int n, int n2) {
        this.initialize();
        this.consumer.setDimensions(n, n2);
    }

    public void setColorModel(ColorModel colorModel) {
        this.consumer.setColorModel(ColorModel.getRGBdefault());
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int[] nArray = new int[n3 * n4];
        int n7 = n5;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n4) {
            int n10 = 0;
            while (n10 < n3) {
                nArray[n8++] = colorModel.getRGB(byArray[n7++]);
                ++n10;
            }
            n7 += n6 - n3;
            ++n9;
        }
        switch (this.type) {
            case 0: 
            case 1: {
                this.linearGradient(nArray, n, n2, n3, n4);
                break;
            }
            case 3: 
            case 4: {
                this.conicalGradient(nArray, n3, n4);
                break;
            }
            case 5: {
                this.squareGradient(nArray, n3, n4);
                break;
            }
        }
        this.consumer.setPixels(n, n2, n3, n4, colorModel, nArray, 0, n3);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int[] nArray2 = new int[n3 * n4];
        int n7 = n5;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n4) {
            int n10 = 0;
            while (n10 < n3) {
                nArray2[n8++] = colorModel.getRGB(nArray[n7++]);
                ++n10;
            }
            n7 += n6 - n3;
            ++n9;
        }
        switch (this.type) {
            case 0: 
            case 1: {
                this.linearGradient(nArray2, n, n2, n3, n4);
                break;
            }
            case 2: {
                this.radialGradient(nArray2, n3, n4);
                break;
            }
            case 3: 
            case 4: {
                this.conicalGradient(nArray2, n3, n4);
                break;
            }
            case 5: {
                this.squareGradient(nArray2, n3, n4);
                break;
            }
        }
        this.consumer.setPixels(n, n2, n3, n4, colorModel, nArray2, 0, n3);
    }

    private void repeatGradient(int[] nArray, int n, int n2, double d, double d2, double d3) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            double d4 = d;
            int n5 = n;
            while (--n5 >= 0) {
                int n6 = this.type == 1 ? this.colormap.getColor(this.map(ImageMath.triangle(d4))) : this.colormap.getColor(this.map(ImageMath.mod(d4, 1.0)));
                nArray[n3] = PixelUtils.combinePixels(n6, nArray[n3], this.paintMode);
                ++n3;
                d4 += d2;
            }
            d += d3;
            ++n4;
        }
    }

    private void singleGradient(int[] nArray, int n, int n2, double d, double d2, double d3) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            double d4 = d;
            int n6 = n;
            if (d4 <= 0.0) {
                n5 = this.colormap.getColor(0.0);
                do {
                    nArray[n3] = PixelUtils.combinePixels(n5, nArray[n3], this.paintMode);
                    ++n3;
                } while (--n6 > 0 && (d4 += d2) <= 0.0);
            }
            while (d4 < 1.0 && --n6 >= 0) {
                n5 = this.type == 1 ? this.colormap.getColor(this.map(ImageMath.triangle(d4))) : this.colormap.getColor(this.map(d4));
                nArray[n3] = PixelUtils.combinePixels(n5, nArray[n3], this.paintMode);
                ++n3;
                d4 += d2;
            }
            if (n6 > 0) {
                n5 = this.type == 1 ? this.colormap.getColor(0.0) : this.colormap.getColor(1.0);
                do {
                    nArray[n3] = PixelUtils.combinePixels(n5, nArray[n3], this.paintMode);
                    ++n3;
                } while (--n6 > 0);
            }
            d += d3;
            ++n4;
        }
    }

    private void linearGradient(int[] nArray, int n, int n2, int n3, int n4) {
        double d = ((double)n - this.x1) * this.dx + ((double)n2 - this.y1) * this.dy;
        if (this.repeat) {
            this.repeatGradient(nArray, n3, n4, d, this.dx, this.dy);
        } else {
            this.singleGradient(nArray, n3, n4, d, this.dx, this.dy);
        }
    }

    private void radialGradient(int[] nArray, int n, int n2) {
        int n3 = 0;
        double d = this.distance(this.p2.x - this.p1.x, this.p2.y - this.p1.y);
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                double d2 = this.distance(n5 - this.p1.x, n4 - this.p1.y);
                double d3 = d2 / d;
                if (this.repeat) {
                    d3 %= 2.0;
                } else if (d3 > 1.0) {
                    d3 = 1.0;
                }
                int n6 = this.colormap.getColor(this.map(d3));
                nArray[n3] = PixelUtils.combinePixels(n6, nArray[n3], this.paintMode);
                ++n3;
                ++n5;
            }
            ++n4;
        }
    }

    private void squareGradient(int[] nArray, int n, int n2) {
        int n3 = 0;
        double d = Math.max(Math.abs(this.p2.x - this.p1.x), Math.abs(this.p2.y - this.p1.y));
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                double d2 = Math.max(Math.abs(n5 - this.p1.x), Math.abs(n4 - this.p1.y));
                double d3 = d2 / d;
                if (this.repeat) {
                    d3 %= 2.0;
                } else if (d3 > 1.0) {
                    d3 = 1.0;
                }
                int n6 = this.colormap.getColor(this.map(d3));
                nArray[n3] = PixelUtils.combinePixels(n6, nArray[n3], this.paintMode);
                ++n3;
                ++n5;
            }
            ++n4;
        }
    }

    private void conicalGradient(int[] nArray, int n, int n2) {
        int n3 = 0;
        double d = Math.atan2(this.p2.x - this.p1.x, this.p2.y - this.p1.y);
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                double d2 = (Math.atan2(n5 - this.p1.x, n4 - this.p1.y) - d) / (Math.PI * 2);
                d2 += 1.0;
                d2 %= 1.0;
                if (this.type == 4) {
                    d2 = ImageMath.triangle(d2);
                }
                int n6 = this.colormap.getColor(this.map(d2));
                nArray[n3] = PixelUtils.combinePixels(n6, nArray[n3], this.paintMode);
                ++n3;
                ++n5;
            }
            ++n4;
        }
    }

    private double map(double d) {
        if (this.repeat) {
            d = d > 1.0 ? 2.0 - d : d;
        }
        switch (this.interpolation) {
            case 1: {
                d = ImageMath.circleUp(ImageMath.clamp(d, 0.0, 1.0));
                break;
            }
            case 2: {
                d = ImageMath.circleDown(ImageMath.clamp(d, 0.0, 1.0));
                break;
            }
            case 3: {
                d = ImageMath.smoothStep(0.0, 1.0, d);
                break;
            }
        }
        return d;
    }

    private double distance(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    public String toString() {
        return "Other/Gradient Fill...";
    }
}

