/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import jj.play.ns.com.jhlabs.image.ConvolveFilter;
import jj.play.ns.com.jhlabs.image.Kernel;

public class GaussianFilter
extends ConvolveFilter {
    static final long serialVersionUID = 5377089073023183684L;
    protected int radius;

    public GaussianFilter() {
        this(2);
    }

    public GaussianFilter(int n) {
        this.setRadius(n);
    }

    public void setRadius(int n) {
        this.radius = n;
        this.setKernel(GaussianFilter.makeKernel(n));
    }

    public int getRadius() {
        return this.radius;
    }

    public static Kernel makeKernel(int n) {
        int n2;
        int n3 = n2 = n * 2 + 1;
        double[] dArray = new double[n2 * n3];
        double d = (double)n / 3.0;
        double d2 = n * n;
        int n4 = 0;
        int n5 = -n;
        while (n5 <= n) {
            int n6 = -n;
            while (n6 <= n) {
                double d3 = n5 * n5 + n6 * n6;
                dArray[n4] = d3 > d2 ? 0.0 : Math.exp(-d3 / (2.0 * d * d)) / (Math.PI * 2 * d);
                ++n4;
                ++n6;
            }
            ++n5;
        }
        Kernel kernel = new Kernel(n2, n3, dArray);
        kernel.normalize();
        return kernel;
    }

    public String toString() {
        return "Blur/Gaussian Blur...";
    }
}

