/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import jj.play.ns.com.jhlabs.image.Kernel;
import jj.play.ns.com.jhlabs.image.PixelUtils;
import jj.play.ns.com.jhlabs.image.WholeImageFilter;

public class EdgeFilter
extends WholeImageFilter {
    static final long serialVersionUID = -1084121755410916989L;
    protected double[] vEdgeMatrix = Kernel.PREWITT_V;
    protected double[] hEdgeMatrix = Kernel.PREWITT_H;

    public void setVEdgeMatrix(double[] dArray) {
        this.vEdgeMatrix = dArray;
    }

    public double[] getVEdgeMatrix() {
        return this.vEdgeMatrix;
    }

    public void setHEdgeMatrix(double[] dArray) {
        this.hEdgeMatrix = dArray;
    }

    public double[] getHEdgeMatrix() {
        return this.hEdgeMatrix;
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int n2 = this.originalSpace.width;
        int n3 = this.originalSpace.height;
        int n4 = 0;
        int[] nArray = new int[n2 * n3];
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                int n16 = this.inPixels[n5 * n2 + n6] & 0xFF000000;
                int n17 = -1;
                while (n17 <= 1) {
                    int n18 = n5 + n17;
                    int n19 = n18 >= 0 && n18 < n3 ? n18 * n2 : n5 * n2;
                    int n20 = 3 * (n17 + 1) + 1;
                    int n21 = -1;
                    while (n21 <= 1) {
                        int n22 = n6 + n21;
                        if (n22 < 0 || n22 >= n2) {
                            n22 = n6;
                        }
                        int n23 = this.inPixels[n19 + n22];
                        double d = this.hEdgeMatrix[n20 + n21];
                        double d2 = this.vEdgeMatrix[n20 + n21];
                        n7 = (n23 & 0xFF0000) >> 16;
                        n8 = (n23 & 0xFF00) >> 8;
                        n9 = n23 & 0xFF;
                        n10 += (int)(d * (double)n7);
                        n11 += (int)(d * (double)n8);
                        n12 += (int)(d * (double)n9);
                        n13 += (int)(d2 * (double)n7);
                        n14 += (int)(d2 * (double)n8);
                        n15 += (int)(d2 * (double)n9);
                        ++n21;
                    }
                    ++n17;
                }
                n7 = (int)(Math.sqrt(n10 * n10 + n13 * n13) / 1.8);
                n8 = (int)(Math.sqrt(n11 * n11 + n14 * n14) / 1.8);
                n9 = (int)(Math.sqrt(n12 * n12 + n15 * n15) / 1.8);
                n7 = PixelUtils.clamp(n7);
                n8 = PixelUtils.clamp(n8);
                n9 = PixelUtils.clamp(n9);
                nArray[n4++] = n16 | n7 << 16 | n8 << 8 | n9;
                ++n6;
            }
            ++n5;
        }
        this.consumer.setPixels(0, 0, n2, n3, this.defaultRGBModel, nArray, 0, n2);
        this.consumer.imageComplete(n);
        this.inPixels = null;
    }

    public String toString() {
        return "Blur/Detect Edges";
    }
}

