/*
 * Decompiled with CFR 0.152.
 */
package jj.play.org.eclipse.mylyn.wikitext.core.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jj.play.org.eclipse.core.runtime.IProgressMonitor;
import jj.play.org.eclipse.mylyn.wikitext.core.validation.Messages;
import jj.play.org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;
import jj.play.org.eclipse.mylyn.wikitext.core.validation.ValidationRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupValidator {
    private final List<ValidationRule> rules = new ArrayList<ValidationRule>();

    public List<ValidationProblem> validate(IProgressMonitor monitor, String markup) {
        return this.validate(monitor, markup, 0, markup.length());
    }

    public List<ValidationProblem> validate(IProgressMonitor monitor, String markup, int offset, int length) {
        int totalWork = length == 0 || this.rules.isEmpty() ? 1 : this.rules.size();
        monitor.beginTask(Messages.getString("MarkupValidator.0"), totalWork);
        try {
            if (length == 0 || this.rules.isEmpty()) {
                List<ValidationProblem> list = Collections.emptyList();
                return list;
            }
            int end = offset + length;
            if (end > markup.length()) {
                end = markup.length();
            }
            ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
            for (ValidationRule rule : this.rules) {
                problems.addAll(rule.findProblems(markup, offset, length));
                monitor.worked(1);
            }
            if (!problems.isEmpty()) {
                Collections.sort(problems);
            }
            ArrayList<ValidationProblem> arrayList = problems;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    public List<ValidationRule> getRules() {
        return this.rules;
    }
}

