/*
 * Decompiled with CFR 0.152.
 */
package jj.play.org.eclipse.mylyn.wikitext.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import jj.play.org.eclipse.mylyn.wikitext.core.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLocator {
    private static final String UTF_8 = "utf-8";
    protected final ClassLoader classLoader;
    private static Class<? extends ServiceLocator> implementationClass;

    protected ServiceLocator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static ServiceLocator getInstance(ClassLoader classLoader) {
        if (implementationClass != null) {
            try {
                return implementationClass.getConstructor(ClassLoader.class).newInstance(classLoader);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return new ServiceLocator(classLoader);
    }

    public static ServiceLocator getInstance() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            ServiceLocator.class.getClassLoader();
        }
        return ServiceLocator.getInstance(loader);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MarkupLanguage getMarkupLanguage(String languageName) throws IllegalArgumentException {
        String className;
        if (languageName == null) {
            throw new IllegalArgumentException();
        }
        Pattern classNamePattern = Pattern.compile("\\s*([^\\s#]+)?#?.*");
        TreeSet<String> names = new TreeSet<String>();
        try {
            String servicesFilename = "META-INF/services/" + MarkupLanguage.class.getName();
            Enumeration<URL> resources = this.classLoader.getResources(servicesFilename);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), UTF_8));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            MarkupLanguage instance;
                            String className2;
                            Matcher matcher = classNamePattern.matcher(line);
                            if (!matcher.matches() || (className2 = matcher.group(1)) == null) continue;
                            try {
                                Class<?> clazz = Class.forName(className2, true, this.classLoader);
                                if (!MarkupLanguage.class.isAssignableFrom(clazz)) continue;
                                instance = (MarkupLanguage)clazz.newInstance();
                                if (languageName.equals(instance.getName())) {
                                    MarkupLanguage markupLanguage = instance;
                                    return markupLanguage;
                                }
                            }
                            catch (Exception e) {
                                Logger.getLogger(ServiceLocator.class.getName()).log(Level.WARNING, MessageFormat.format(Messages.getString("ServiceLocator.0"), className2), e);
                                continue;
                            }
                            {
                                names.add(instance.getName());
                            }
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            Logger.getLogger(ServiceLocator.class.getName()).log(Level.SEVERE, Messages.getString("ServiceLocator.1"), e);
        }
        Matcher matcher = classNamePattern.matcher(languageName);
        if (matcher.matches() && (className = matcher.group(1)) != null) {
            try {
                Class<?> clazz = Class.forName(className, true, this.classLoader);
                if (MarkupLanguage.class.isAssignableFrom(clazz)) {
                    return (MarkupLanguage)clazz.newInstance();
                }
            }
            catch (Exception exception) {}
        }
        StringBuilder buf = new StringBuilder();
        Iterator iterator = names.iterator();
        while (true) {
            block21: {
                if (iterator.hasNext()) break block21;
            }
            String name = (String)iterator.next();
            if (buf.length() != 0) {
                buf.append(", ");
            }
            buf.append('\'');
            buf.append(name);
            buf.append('\'');
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("ServiceLocator.4"), languageName, buf.length() == 0 ? Messages.getString("ServiceLocator.5") : String.valueOf(Messages.getString("ServiceLocator.6")) + buf));
    }

    public static void setImplementation(Class<? extends ServiceLocator> implementationClass) {
        ServiceLocator.implementationClass = implementationClass;
    }
}

