/*
 * Decompiled with CFR 0.152.
 */
package jj.play.org.eclipse.mylyn.internal.wikitext.core.util.css;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SparseCharSequence
implements CharSequence {
    private final CharSequence data;
    private final Segment[] segments;
    private final int length;

    public SparseCharSequence(CharSequence data, Pattern excludePattern) {
        this.data = data;
        ArrayList<Segment> segments = new ArrayList<Segment>(5);
        Segment segment = new Segment(0, 0);
        Matcher matcher = excludePattern.matcher(data);
        while (matcher.find()) {
            segment.length = matcher.start() - segment.offset;
            segments.add(segment);
            int end = matcher.end();
            if (end == data.length()) {
                segment = null;
                break;
            }
            segment = new Segment(end, segment.zeroBase + segment.length);
        }
        if (segment != null) {
            segment.length = data.length() - segment.offset;
            segments.add(segment);
        }
        if (segments.size() > 1) {
            Iterator it = segments.iterator();
            while (it.hasNext() && segments.size() > 1) {
                segment = (Segment)it.next();
                if (segment.length != 0) continue;
                it.remove();
            }
        }
        this.segments = segments.toArray(new Segment[segments.size()]);
        Segment lastSegment = this.segments[this.segments.length - 1];
        this.length = lastSegment.zeroBase + lastSegment.length;
    }

    public int originalOffsetOf(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException(String.format("%s is not within [0,%s)", index, this.length()));
        }
        Segment segment = this.segmentOf(index);
        return segment.offset + (index - segment.zeroBase);
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException(String.format("%s is not within [0,%s)", index, this.length()));
        }
        Segment segment = this.segmentOf(index);
        return this.data.charAt(segment.offset + (index - segment.zeroBase));
    }

    private Segment segmentOf(int index) {
        if (index == 0) {
            return this.segments[0];
        }
        Segment candidate = this.segments[0];
        int x = 1;
        while (x < this.segments.length) {
            if (this.segments[x].zeroBase > index) break;
            candidate = this.segments[x];
            ++x;
        }
        return candidate;
    }

    public int length() {
        return this.length;
    }

    public CharSequence subSequence(int start, int end) {
        if (start < 0 || start >= this.length || end > this.length) {
            throw new IndexOutOfBoundsException(String.format("[%s,%s) is not within range [0,%s)", start, end, this.length));
        }
        int rangeLength = end - start;
        if (rangeLength == 0) {
            return "";
        }
        int remainingLength = rangeLength;
        String sequence = null;
        Segment segment = this.segmentOf(start);
        while (remainingLength > 0) {
            int segmentOffset = start - segment.zeroBase;
            int segmentEnd = Math.min(end - segment.zeroBase, segment.length);
            CharSequence part = this.data.subSequence(segment.offset + segmentOffset, segment.offset + segmentEnd);
            sequence = sequence == null ? part.toString() : String.valueOf(sequence) + part;
            start += part.length();
            segment = this.segmentOf(end - (remainingLength -= part.length()));
        }
        return sequence;
    }

    public String toString() {
        return this.subSequence(0, this.length).toString();
    }

    private static class Segment {
        int offset;
        int length;
        int zeroBase;

        public Segment(int offset, int zeroBase) {
            this.offset = offset;
            this.zeroBase = zeroBase;
        }
    }
}

