/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.canvas;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.gae.GAEUtils;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.ImageData;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.rendering.AwtRenderingBackend;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.rendering.GaeRenderingBackend;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.rendering.RenderingBackend;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCanvasElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLImageElement;
import java.io.IOException;
import javax.imageio.ImageReader;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class CanvasRenderingContext2D
extends SimpleScriptable {
    private final HTMLCanvasElement canvas_;
    private RenderingBackend renderingBackend_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public CanvasRenderingContext2D() {
        this.canvas_ = null;
        this.renderingBackend_ = null;
    }

    public CanvasRenderingContext2D(HTMLCanvasElement canvas) {
        this.canvas_ = canvas;
        this.renderingBackend_ = null;
    }

    private RenderingBackend getRenderingBackend() {
        if (this.renderingBackend_ == null) {
            int imageWidth = Math.max(1, this.canvas_.getWidth());
            int imageHeight = Math.max(1, this.canvas_.getHeight());
            this.renderingBackend_ = GAEUtils.isGaeMode() ? new GaeRenderingBackend(imageWidth, imageHeight) : new AwtRenderingBackend(imageWidth, imageHeight);
        }
        return this.renderingBackend_;
    }

    @JsxGetter
    public Object getFillStyle() {
        return null;
    }

    @JsxSetter
    public void setFillStyle(String fillStyle) {
        this.getRenderingBackend().setFillStyle(fillStyle);
    }

    @JsxGetter
    public Object getStrokeStyle() {
        return null;
    }

    @JsxSetter
    public void setStrokeStyle(Object strokeStyle) {
    }

    @JsxGetter
    public double getLineWidth() {
        return 0.0;
    }

    @JsxSetter
    public void setLineWidth(Object lineWidth) {
    }

    @JsxGetter
    public double getGlobalAlpha() {
        return 0.0;
    }

    @JsxSetter
    public void setGlobalAlpha(Object globalAlpha) {
    }

    @JsxFunction
    public void arc(double x, double y, double radius, double startAngle, double endAngle, boolean anticlockwise) {
    }

    @JsxFunction
    public void arcTo(double x1, double y1, double x2, double y2, double radius) {
    }

    @JsxFunction
    public void beginPath() {
    }

    @JsxFunction
    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
    }

    @JsxFunction
    public void clearRect(double x, double y, double w, double h) {
    }

    @JsxFunction
    public void clip() {
    }

    @JsxFunction
    public void closePath() {
    }

    @JsxFunction
    public void createImageData() {
    }

    @JsxFunction
    public void createLinearGradient(double x0, double y0, double r0, double x1, Object y1, Object r1) {
    }

    @JsxFunction
    public void createPattern() {
    }

    @JsxFunction
    public void createRadialGradient() {
    }

    @JsxFunction
    public void drawImage(Object image, int sx, int sy, Object sWidth, Object sHeight, Object dx, Object dy, Object dWidth, Object dHeight) {
        block6: {
            Integer dyI;
            Integer dxI;
            Integer dWidthI = null;
            Integer dHeightI = null;
            Integer sWidthI = null;
            Integer sHeightI = null;
            if (dx != Undefined.instance) {
                dxI = ((Number)dx).intValue();
                dyI = ((Number)dy).intValue();
                dWidthI = ((Number)dWidth).intValue();
                dHeightI = ((Number)dHeight).intValue();
            } else {
                dxI = sx;
                dyI = sy;
            }
            if (sWidth != Undefined.instance) {
                sWidthI = ((Number)sWidth).intValue();
                sHeightI = ((Number)sHeight).intValue();
            }
            try {
                if (image instanceof HTMLImageElement) {
                    ImageReader imageReader = ((HtmlImage)((HTMLImageElement)image).getDomNodeOrDie()).getImageReader();
                    this.getRenderingBackend().drawImage(imageReader, dxI, dyI);
                }
            }
            catch (IOException ioe) {
                if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CANVAS_DRAW_THROWS_FOR_MISSING_IMG)) break block6;
                throw Context.throwAsScriptRuntimeEx((Throwable)ioe);
            }
        }
    }

    public String toDataURL(String type) {
        try {
            if (type == null) {
                type = "png";
            }
            return "data:" + type + ";base64," + this.getRenderingBackend().encodeToString(type);
        }
        catch (IOException ioe) {
            throw Context.throwAsScriptRuntimeEx((Throwable)ioe);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME)})
    public void ellipse(double x, double y, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, boolean anticlockwise) {
    }

    @JsxFunction
    public void fill() {
    }

    @JsxFunction
    public void fillRect(int x, int y, int w, int h) {
        this.getRenderingBackend().fillRect(x, y, w, h);
    }

    @JsxFunction
    public void fillText() {
    }

    @JsxFunction
    public ImageData getImageData(int sx, int sy, int sw, int sh) {
        ImageData imageData = new ImageData(this.getRenderingBackend(), sx, sy, sw, sh);
        imageData.setParentScope(this.getParentScope());
        imageData.setPrototype(this.getPrototype(imageData.getClass()));
        return imageData;
    }

    @JsxFunction
    public void getLineDash() {
    }

    @JsxFunction
    public void getLineData() {
    }

    @JsxFunction
    public void isPointInPath() {
    }

    @JsxFunction
    public void lineTo(double x, double y) {
    }

    @JsxFunction
    public void measureText() {
    }

    @JsxFunction
    public void moveTo(double x, double y) {
    }

    @JsxFunction
    public void putImageData() {
    }

    @JsxFunction
    public void quadraticCurveTo(double controlPointX, double controlPointY, double endPointX, double endPointY) {
    }

    @JsxFunction
    public void rect() {
    }

    @JsxFunction
    public void restore() {
    }

    @JsxFunction
    public void rotate() {
    }

    @JsxFunction
    public void save() {
    }

    @JsxFunction
    public void scale(Object x, Object y) {
    }

    @JsxFunction
    public void setLineDash() {
    }

    @JsxFunction
    public void setTransform() {
    }

    @JsxFunction
    public void stroke() {
    }

    @JsxFunction
    public void strokeRect(double x, double y, double w, double h) {
    }

    @JsxFunction
    public void strokeText() {
    }

    @JsxFunction
    public void transform() {
    }

    @JsxFunction
    public void translate(Object x, Object y) {
    }

    @JsxGetter
    public HTMLCanvasElement getCanvas() {
        return this.canvas_;
    }
}

