/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util.internal;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.jboss.netty.util.internal.DetectionUtil;

public final class SocketUtil {
    private static final String ZONE_ID_SEPARATOR = "%";

    public static InetSocketAddress stripZoneId(InetSocketAddress socketAddress) {
        String hostaddress;
        int separator;
        Inet6Address inet6Address;
        if (DetectionUtil.javaVersion() >= 7) {
            return socketAddress;
        }
        InetAddress address = socketAddress.getAddress();
        if (address instanceof Inet6Address && (inet6Address = (Inet6Address)address).isLinkLocalAddress() && (separator = (hostaddress = inet6Address.getHostAddress()).indexOf(ZONE_ID_SEPARATOR)) != -1) {
            String withoutZonedId = inet6Address.getHostAddress().substring(0, separator);
            return new InetSocketAddress(withoutZonedId, socketAddress.getPort());
        }
        return socketAddress;
    }

    private SocketUtil() {
    }
}

