/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;

public final class SpdyHttpHeaders {
    private SpdyHttpHeaders() {
    }

    public static void removeStreamID(HttpMessage message) {
        message.removeHeader("X-SPDY-Stream-ID");
    }

    public static int getStreamID(HttpMessage message) {
        return HttpHeaders.getIntHeader(message, "X-SPDY-Stream-ID");
    }

    public static void setStreamID(HttpMessage message, int streamID) {
        HttpHeaders.setIntHeader(message, "X-SPDY-Stream-ID", streamID);
    }

    public static void removeAssociatedToStreamID(HttpMessage message) {
        message.removeHeader("X-SPDY-Associated-To-Stream-ID");
    }

    public static int getAssociatedToStreamID(HttpMessage message) {
        return HttpHeaders.getIntHeader(message, "X-SPDY-Associated-To-Stream-ID", 0);
    }

    public static void setAssociatedToStreamID(HttpMessage message, int associatedToStreamID) {
        HttpHeaders.setIntHeader(message, "X-SPDY-Associated-To-Stream-ID", associatedToStreamID);
    }

    public static void removePriority(HttpMessage message) {
        message.removeHeader("X-SPDY-Priority");
    }

    public static byte getPriority(HttpMessage message) {
        return (byte)HttpHeaders.getIntHeader(message, "X-SPDY-Priority", 0);
    }

    public static void setPriority(HttpMessage message, byte priority) {
        HttpHeaders.setIntHeader(message, "X-SPDY-Priority", priority);
    }

    public static void removeUrl(HttpMessage message) {
        message.removeHeader("X-SPDY-URL");
    }

    public static String getUrl(HttpMessage message) {
        return message.getHeader("X-SPDY-URL");
    }

    public static void setUrl(HttpMessage message, String url) {
        message.setHeader("X-SPDY-URL", url);
    }

    public static final class Names {
        public static final String STREAM_ID = "X-SPDY-Stream-ID";
        public static final String ASSOCIATED_TO_STREAM_ID = "X-SPDY-Associated-To-Stream-ID";
        public static final String PRIORITY = "X-SPDY-Priority";
        public static final String URL = "X-SPDY-URL";

        private Names() {
        }
    }
}

