/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.http;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import oauth.signpost.OAuth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestParameters
implements Map<String, SortedSet<String>> {
    private static final long serialVersionUID = -2281503352590395824L;
    private TreeMap<String, SortedSet<String>> wrappedMap = new TreeMap();

    @Override
    public SortedSet<String> put(String key, SortedSet<String> value) {
        return this.wrappedMap.put(key, value);
    }

    @Override
    public String put(String key, String value) {
        SortedSet<String> values = this.wrappedMap.get(key);
        if (values == null) {
            values = new TreeSet<String>();
            this.wrappedMap.put(OAuth.percentEncode(key), values);
        }
        value = OAuth.percentEncode(value);
        values.add(value);
        return value;
    }

    public String putNull(String key, String nullString) {
        return this.put(key, nullString);
    }

    @Override
    public void putAll(Map<? extends String, ? extends SortedSet<String>> m) {
        this.wrappedMap.putAll(m);
    }

    public void putMap(Map<? extends String, ? extends String> m) {
        for (String string : m.keySet()) {
            this.put(string, m.get(string));
        }
    }

    @Override
    public SortedSet<String> get(Object key) {
        return this.wrappedMap.get(key);
    }

    public String getFormEncoded(Object key) {
        StringBuilder sb = new StringBuilder();
        Set values = this.wrappedMap.get(key = OAuth.percentEncode((String)key));
        if (values == null) {
            return key + "=";
        }
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            sb.append(key + "=" + (String)iter.next());
            if (!iter.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    public String getAsHeaderElement(String key) {
        String value = (String)this.get(key).first();
        if (value == null) {
            return null;
        }
        return key + "=\"" + value + "\"";
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrappedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (SortedSet<String> values : this.wrappedMap.values()) {
            if (!values.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        int count = 0;
        for (String key : this.wrappedMap.keySet()) {
            count += this.wrappedMap.get(key).size();
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedMap.isEmpty();
    }

    @Override
    public void clear() {
        this.wrappedMap.clear();
    }

    @Override
    public SortedSet<String> remove(Object key) {
        return this.wrappedMap.remove(key);
    }

    @Override
    public Set<String> keySet() {
        return this.wrappedMap.keySet();
    }

    @Override
    public Collection<SortedSet<String>> values() {
        return this.wrappedMap.values();
    }

    @Override
    public Set<Map.Entry<String, SortedSet<String>>> entrySet() {
        return this.wrappedMap.entrySet();
    }
}

