/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Random;
import oauth.signpost.OAuth;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.basic.UrlStringRequestAdapter;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.http.HttpRequest;
import oauth.signpost.http.RequestParameters;
import oauth.signpost.signature.AuthorizationHeaderSigningStrategy;
import oauth.signpost.signature.HmacSha1MessageSigner;
import oauth.signpost.signature.OAuthMessageSigner;
import oauth.signpost.signature.QueryStringSigningStrategy;
import oauth.signpost.signature.SigningStrategy;

public abstract class AbstractOAuthConsumer
implements OAuthConsumer {
    private static final long serialVersionUID = 1L;
    private String consumerKey;
    private String consumerSecret;
    private String token;
    private OAuthMessageSigner messageSigner;
    private SigningStrategy signingStrategy;
    private RequestParameters requestParameters;
    private boolean sendEmptyTokens;

    public AbstractOAuthConsumer(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.setMessageSigner(new HmacSha1MessageSigner());
        this.setSigningStrategy(new AuthorizationHeaderSigningStrategy());
    }

    public void setMessageSigner(OAuthMessageSigner messageSigner) {
        this.messageSigner = messageSigner;
        messageSigner.setConsumerSecret(this.consumerSecret);
    }

    public void setSigningStrategy(SigningStrategy signingStrategy) {
        this.signingStrategy = signingStrategy;
    }

    public HttpRequest sign(HttpRequest request) throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException {
        if (this.consumerKey == null) {
            throw new OAuthExpectationFailedException("consumer key not set");
        }
        if (this.consumerSecret == null) {
            throw new OAuthExpectationFailedException("consumer secret not set");
        }
        this.requestParameters = new RequestParameters();
        try {
            this.collectHeaderParameters(request, this.requestParameters);
            this.collectQueryParameters(request, this.requestParameters);
            this.collectBodyParameters(request, this.requestParameters);
            this.completeOAuthParameters(this.requestParameters);
            this.requestParameters.remove("oauth_signature");
        }
        catch (IOException e) {
            throw new OAuthCommunicationException(e);
        }
        String signature = this.messageSigner.sign(request, this.requestParameters);
        OAuth.debugOut("signature", signature);
        this.signingStrategy.writeSignature(signature, request, this.requestParameters);
        return request;
    }

    public HttpRequest sign(Object request) throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException {
        return this.sign(this.wrap(request));
    }

    public String sign(String url) throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException {
        UrlStringRequestAdapter request = new UrlStringRequestAdapter(url);
        SigningStrategy oldStrategy = this.signingStrategy;
        this.signingStrategy = new QueryStringSigningStrategy();
        this.sign(request);
        this.signingStrategy = oldStrategy;
        return request.getRequestUrl();
    }

    protected abstract HttpRequest wrap(Object var1);

    public void setTokenWithSecret(String token, String tokenSecret) {
        this.token = token;
        this.messageSigner.setTokenSecret(tokenSecret);
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenSecret() {
        return this.messageSigner.getTokenSecret();
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    protected void completeOAuthParameters(RequestParameters out) {
        if (!out.containsKey("oauth_consumer_key")) {
            out.put("oauth_consumer_key", this.consumerKey);
        }
        if (!out.containsKey("oauth_signature_method")) {
            out.put("oauth_signature_method", this.messageSigner.getSignatureMethod());
        }
        if (!out.containsKey("oauth_timestamp")) {
            out.put("oauth_timestamp", this.generateTimestamp());
        }
        if (!out.containsKey("oauth_nonce")) {
            out.put("oauth_nonce", this.generateNonce());
        }
        if (!out.containsKey("oauth_version")) {
            out.put("oauth_version", "1.0");
        }
        if (!out.containsKey("oauth_token") && (this.token != null && !this.token.equals("") || this.sendEmptyTokens)) {
            out.put("oauth_token", this.token);
        }
    }

    public RequestParameters getRequestParameters() {
        return this.requestParameters;
    }

    public void setSendEmptyTokens(boolean enable) {
        this.sendEmptyTokens = enable;
    }

    protected void collectHeaderParameters(HttpRequest request, RequestParameters out) {
        Map<String, String> headerParams = OAuth.oauthHeaderToParamsMap(request.getHeader("Authorization"));
        out.putMap(headerParams);
    }

    protected void collectBodyParameters(HttpRequest request, RequestParameters out) throws IOException {
        String contentType = request.getContentType();
        if (contentType != null && contentType.startsWith("application/x-www-form-urlencoded")) {
            InputStream payload = request.getMessagePayload();
            out.putMap(OAuth.decodeForm(payload));
        }
    }

    protected void collectQueryParameters(HttpRequest request, RequestParameters out) {
        String url = request.getRequestUrl();
        int q = url.indexOf(63);
        if (q >= 0) {
            out.putMap(OAuth.decodeForm(url.substring(q + 1)));
        }
    }

    protected String generateTimestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    protected String generateNonce() {
        return Long.toString(new Random().nextLong());
    }
}

