/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.NotMemberOf;
import net.sf.oval.context.OValContext;
import net.sf.oval.internal.util.ArrayUtils;
import net.sf.oval.internal.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotMemberOfCheck
extends AbstractAnnotationCheck<NotMemberOf> {
    private static final long serialVersionUID = 1L;
    private boolean ignoreCase;
    private List<String> members;
    private transient List<String> membersLowerCase;

    @Override
    public void configure(NotMemberOf constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setIgnoreCase(constraintAnnotation.ignoreCase());
        this.setMembers(constraintAnnotation.value());
    }

    public Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("ignoreCase", Boolean.toString(this.ignoreCase));
        messageVariables.put("members", StringUtils.implode(this.members, ","));
        return messageVariables;
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public List<String> getMembers() {
        List<String> v = Validator.getCollectionFactory().createList();
        v.addAll(this.members);
        return v;
    }

    private List<String> getMembersLowerCase() {
        if (this.membersLowerCase == null) {
            this.membersLowerCase = Validator.getCollectionFactory().createList(this.members.size());
            for (String val : this.members) {
                this.membersLowerCase.add(val.toLowerCase(Locale.getDefault()));
            }
        }
        return this.membersLowerCase;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        if (valueToValidate == null) {
            return true;
        }
        if (this.ignoreCase) {
            return !this.getMembersLowerCase().contains(valueToValidate.toString().toLowerCase(Locale.getDefault()));
        }
        return !this.members.contains(valueToValidate.toString());
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.requireMessageVariablesRecreation();
    }

    public void setMembers(List<String> members) {
        this.members = Validator.getCollectionFactory().createList();
        this.members.addAll(members);
        this.membersLowerCase = null;
        this.requireMessageVariablesRecreation();
    }

    public void setMembers(String ... members) {
        this.members = Validator.getCollectionFactory().createList();
        ArrayUtils.addAll(this.members, members);
        this.membersLowerCase = null;
        this.requireMessageVariablesRecreation();
    }
}

