/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.util.Map;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.Min;
import net.sf.oval.context.OValContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinCheck
extends AbstractAnnotationCheck<Min> {
    private static final long serialVersionUID = 1L;
    private double min;

    @Override
    public void configure(Min constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMin(constraintAnnotation.value());
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public double getMin() {
        return this.min;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        if (valueToValidate == null) {
            return true;
        }
        if (valueToValidate instanceof Number) {
            double doubleValue = ((Number)valueToValidate).doubleValue();
            return doubleValue >= this.min;
        }
        String stringValue = valueToValidate.toString();
        try {
            double doubleValue = Double.parseDouble(stringValue);
            return doubleValue >= this.min;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void setMin(double min) {
        this.min = min;
        this.requireMessageVariablesRecreation();
    }

    public Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("min", Double.toString(this.min));
        return messageVariables;
    }
}

