/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.nl.captcha.noise;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.security.SecureRandom;
import java.util.Random;
import jj.play.ns.nl.captcha.noise.NoiseProducer;

public class CurvedLineNoiseProducer
implements NoiseProducer {
    private static final Random RAND = new SecureRandom();
    private final Color _color;
    private final float _width;

    public CurvedLineNoiseProducer() {
        this(Color.BLACK, 3.0f);
    }

    public CurvedLineNoiseProducer(Color color, float f) {
        this._color = color;
        this._width = f;
    }

    public void makeNoise(BufferedImage bufferedImage) {
        Object[] objectArray;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        CubicCurve2D.Float float_ = new CubicCurve2D.Float((float)n * 0.1f, (float)n2 * RAND.nextFloat(), (float)n * 0.1f, (float)n2 * RAND.nextFloat(), (float)n * 0.25f, (float)n2 * RAND.nextFloat(), (float)n * 0.9f, (float)n2 * RAND.nextFloat());
        PathIterator pathIterator = float_.getPathIterator(null, 2.0);
        Point2D[] point2DArray = new Point2D[200];
        int n3 = 0;
        while (!pathIterator.isDone()) {
            objectArray = new float[6];
            switch (pathIterator.currentSegment((float[])objectArray)) {
                case 0: 
                case 1: {
                    point2DArray[n3] = new Point2D.Float(objectArray[0], objectArray[1]);
                }
            }
            ++n3;
            pathIterator.next();
        }
        objectArray = new Point2D[n3];
        System.arraycopy(point2DArray, 0, objectArray, 0, n3);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        graphics2D.setColor(this._color);
        for (n3 = 0; n3 < objectArray.length - 1; ++n3) {
            if (n3 < 3) {
                graphics2D.setStroke(new BasicStroke(this._width));
            }
            graphics2D.drawLine((int)objectArray[n3].getX(), (int)objectArray[n3].getY(), (int)objectArray[n3 + 1].getX(), (int)objectArray[n3 + 1].getY());
        }
        graphics2D.dispose();
    }
}

