/*
 * Decompiled with CFR 0.152.
 */
package jj.play.org.eclipse.mylyn.wikitext.core.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.DefaultIdGenerationStrategy;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.IdGenerationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdGenerator {
    private static final DefaultIdGenerationStrategy DEFAULT_ID_GENERATION_STRATEGY = new DefaultIdGenerationStrategy();
    private final Map<String, Integer> idGenerators = new HashMap<String, Integer>();
    private final Set<String> anchorNames = new HashSet<String>();
    private IdGenerationStrategy generationStrategy = DEFAULT_ID_GENERATION_STRATEGY;

    public boolean reserveId(String id) {
        return this.anchorNames.add(id);
    }

    public String newId(String type, String text) {
        Integer current;
        if (type == null) {
            type = "";
        }
        if ((current = this.idGenerators.get(type)) == null) {
            current = 0;
        }
        current = current + 1;
        this.idGenerators.put(type, current);
        String id = null;
        if (text != null) {
            id = this.generationStrategy.generateId(text.trim());
            if (id == null || id.length() == 0) {
                id = String.valueOf(type) + '-' + current;
            }
        } else {
            id = String.valueOf(type) + '-' + current;
        }
        String template = id;
        int suffix = 1;
        while (!this.anchorNames.add(id)) {
            id = String.valueOf(template) + ++suffix;
        }
        return id;
    }

    public Set<String> getAnchorNames() {
        return Collections.unmodifiableSet(this.anchorNames);
    }

    public IdGenerationStrategy getGenerationStrategy() {
        return this.generationStrategy;
    }

    public void setGenerationStrategy(IdGenerationStrategy generationStrategy) {
        if (generationStrategy == null) {
            throw new IllegalArgumentException();
        }
        this.generationStrategy = generationStrategy;
    }
}

