/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.math;

import jj.play.ns.com.jhlabs.math.Function2D;
import jj.play.ns.com.jhlabs.math.Noise;

public class FBM
implements Function2D {
    protected double[] exponents;
    protected double H;
    protected double lacunarity;
    protected double octaves;
    protected Function2D basis;

    public FBM(double d, double d2, double d3) {
        this(d, d2, d3, new Noise());
    }

    public FBM(double d, double d2, double d3, Function2D function2D) {
        this.H = d;
        this.lacunarity = d2;
        this.octaves = d3;
        this.basis = function2D;
        this.exponents = new double[(int)d3 + 1];
        double d4 = 1.0;
        int n = 0;
        while (n <= (int)d3) {
            this.exponents[n] = Math.pow(d4, -d);
            d4 *= d2;
            ++n;
        }
    }

    public double evaluate(double d, double d2) {
        double d3 = 0.0;
        d += 371.0;
        d2 += 529.0;
        int n = 0;
        while (n < (int)this.octaves) {
            d3 += this.basis.evaluate(d, d2) * this.exponents[n];
            d *= this.lacunarity;
            d2 *= this.lacunarity;
            ++n;
        }
        double d4 = this.octaves - (double)((int)this.octaves);
        if (d4 != 0.0) {
            d3 += d4 * this.basis.evaluate(d, d2) * this.exponents[n];
        }
        return d3;
    }
}

