/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.io.Serializable;
import jj.play.ns.com.jhlabs.image.ImageMath;

public class WarpGrid
implements Serializable {
    static final long serialVersionUID = 4312410199770201968L;
    public float[] xGrid = null;
    public float[] yGrid = null;
    public int rows;
    public int cols;

    public WarpGrid(int n, int n2, int n3, int n4) {
        this.rows = n;
        this.cols = n2;
        this.xGrid = new float[n * n2];
        this.yGrid = new float[n * n2];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            int n7 = 0;
            while (n7 < n2) {
                this.xGrid[n5] = (float)n7 * (float)n3 / (float)(n2 - 1);
                this.yGrid[n5] = (float)n6 * (float)n4 / (float)(n - 1);
                ++n5;
                ++n7;
            }
            ++n6;
        }
    }

    public void lerp(double d, WarpGrid warpGrid, WarpGrid warpGrid2) {
        if (this.rows != warpGrid.rows || this.cols != warpGrid.cols) {
            throw new IllegalArgumentException("source and destination are different sizes");
        }
        if (this.rows != warpGrid2.rows || this.cols != warpGrid2.cols) {
            throw new IllegalArgumentException("source and intermediate are different sizes");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.rows) {
            int n3 = 0;
            while (n3 < this.cols) {
                warpGrid2.xGrid[n] = (float)ImageMath.lerp(d, this.xGrid[n], warpGrid.xGrid[n]);
                warpGrid2.yGrid[n] = (float)ImageMath.lerp(d, this.yGrid[n], warpGrid.yGrid[n]);
                ++n;
                ++n3;
            }
            ++n2;
        }
    }

    public void warp(int[] nArray, int n, int n2, WarpGrid warpGrid, WarpGrid warpGrid2, int[] nArray2) {
        try {
            int n3;
            int n4;
            int n5;
            if (warpGrid.rows != warpGrid2.rows || warpGrid.cols != warpGrid2.cols) {
                throw new IllegalArgumentException("source and destination grids are different sizes");
            }
            int n6 = Math.max(n, n2);
            float[] fArray = new float[n6];
            float[] fArray2 = new float[n6];
            float[] fArray3 = new float[n6 + 1];
            float[] fArray4 = new float[n6 + 1];
            int n7 = warpGrid.cols;
            int n8 = warpGrid.rows;
            WarpGrid warpGrid3 = new WarpGrid(n2, n7, 1, 1);
            int n9 = 0;
            while (n9 < n7) {
                n5 = n9;
                n4 = 0;
                while (n4 < n8) {
                    fArray[n4] = warpGrid.xGrid[n5];
                    fArray2[n4] = warpGrid.yGrid[n5];
                    n5 += n7;
                    ++n4;
                }
                this.interpolate(fArray2, fArray, 0, fArray4, 0, n2);
                n5 = n9;
                n3 = 0;
                while (n3 < n2) {
                    warpGrid3.xGrid[n5] = fArray4[n3];
                    n5 += n7;
                    ++n3;
                }
                ++n9;
            }
            n9 = 0;
            while (n9 < n7) {
                n5 = n9;
                n4 = 0;
                while (n4 < n8) {
                    fArray[n4] = warpGrid2.xGrid[n5];
                    fArray2[n4] = warpGrid2.yGrid[n5];
                    n5 += n7;
                    ++n4;
                }
                this.interpolate(fArray2, fArray, 0, fArray4, 0, n2);
                n5 = n9;
                n3 = 0;
                while (n3 < n2) {
                    warpGrid3.yGrid[n5] = fArray4[n3];
                    n5 += n7;
                    ++n3;
                }
                ++n9;
            }
            int[] nArray3 = new int[n2 * n];
            n5 = 0;
            n3 = 0;
            while (n3 < n2) {
                this.interpolate(warpGrid3.xGrid, warpGrid3.yGrid, n5, fArray3, 0, n);
                fArray3[n] = n;
                ImageMath.resample(nArray, nArray3, n, n3 * n, 1, fArray3);
                n5 += n7;
                ++n3;
            }
            warpGrid3 = new WarpGrid(n8, n, 1, 1);
            n5 = 0;
            int n10 = 0;
            n4 = 0;
            while (n4 < n8) {
                this.interpolate(warpGrid.xGrid, warpGrid.yGrid, n5, warpGrid3.xGrid, n10, n);
                n5 += n7;
                n10 += n;
                ++n4;
            }
            n5 = 0;
            n10 = 0;
            n4 = 0;
            while (n4 < n8) {
                this.interpolate(warpGrid2.xGrid, warpGrid2.yGrid, n5, warpGrid3.yGrid, n10, n);
                n5 += n7;
                n10 += n;
                ++n4;
            }
            int n11 = 0;
            while (n11 < n) {
                int n12 = n11;
                n4 = 0;
                while (n4 < n8) {
                    fArray[n4] = warpGrid3.xGrid[n12];
                    fArray2[n4] = warpGrid3.yGrid[n12];
                    n12 += n;
                    ++n4;
                }
                this.interpolate(fArray, fArray2, 0, fArray3, 0, n2);
                fArray3[n2] = n2;
                ImageMath.resample(nArray3, nArray2, n2, n11, n, fArray3);
                ++n11;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void interpolate(float[] fArray, float[] fArray2, int n, float[] fArray3, int n2, int n3) {
        int n4 = n;
        float f = fArray[n4];
        float f2 = fArray2[n4];
        float f3 = fArray[n4 + 1];
        float f4 = fArray2[n4 + 1];
        int n5 = 0;
        while (n5 < n3) {
            if ((float)n5 > fArray[n4]) {
                f = fArray[n4];
                f2 = fArray2[n4];
                f3 = fArray[++n4];
                f4 = fArray2[n4];
            }
            float f5 = ((float)n5 - f) / (f3 - f);
            fArray3[n2 + n5] = f2 + f5 * (f4 - f2);
            ++n5;
        }
    }
}

