/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.awt.image.RGBImageFilter;
import java.io.Serializable;
import jj.play.ns.com.jhlabs.image.Colormap;
import jj.play.ns.com.jhlabs.image.Gradient;
import jj.play.ns.com.jhlabs.image.ImageMath;
import jj.play.ns.com.jhlabs.image.PixelUtils;
import jj.play.ns.com.jhlabs.math.Function2D;
import jj.play.ns.com.jhlabs.math.Noise;

public class TextureFilter
extends RGBImageFilter
implements Serializable {
    static final long serialVersionUID = -7538331862272404352L;
    private double scale = 32.0;
    private double stretch = 1.0;
    private double angle = 0.0;
    public double amount = 1.0;
    public double turbulence = 1.0;
    public double gain = 0.5;
    public double bias = 0.5;
    public int operation;
    private double m00 = 1.0;
    private double m01 = 0.0;
    private double m10 = 0.0;
    private double m11 = 1.0;
    private Colormap colormap = new Gradient();
    private Function2D function = new Noise();

    public void setAmount(double d) {
        this.amount = d;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setFunction(Function2D function2D) {
        this.function = function2D;
    }

    public Function2D getFunction() {
        return this.function;
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public double getScale() {
        return this.scale;
    }

    public void setStretch(double d) {
        this.stretch = d;
    }

    public double getStretch() {
        return this.stretch;
    }

    public void setAngle(double d) {
        this.angle = d;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.m00 = d2;
        this.m01 = d3;
        this.m10 = -d3;
        this.m11 = d2;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setTurbulence(double d) {
        this.turbulence = d;
    }

    public double getTurbulence() {
        return this.turbulence;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4;
        double d = this.m00 * (double)n + this.m01 * (double)n2;
        double d2 = this.m10 * (double)n + this.m11 * (double)n2;
        double d3 = this.turbulence == 1.0 ? Noise.noise2(d, d2) : Noise.turbulence2(d /= this.scale, d2 /= this.scale * this.stretch, this.turbulence);
        d3 = d3 * 0.5 + 0.5;
        d3 = ImageMath.gain(d3, this.gain);
        d3 = ImageMath.bias(d3, this.bias);
        d3 *= this.amount;
        int n5 = n3 & 0xFF000000;
        if (this.colormap != null) {
            n4 = this.colormap.getColor(d3);
        } else {
            n4 = PixelUtils.clamp((int)(d3 * 255.0));
            int n6 = n4 << 16;
            int n7 = n4 << 8;
            int n8 = n4;
            n4 = n5 | n6 | n7 | n8;
        }
        if (this.operation != 0) {
            n4 = PixelUtils.combinePixels(n3, n4, this.operation);
        }
        return n4;
    }

    public String toString() {
        return "Texture/Noise...";
    }
}

