/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import jj.play.ns.com.jhlabs.image.Colormap;
import jj.play.ns.com.jhlabs.image.PixelUtils;
import jj.play.ns.com.jhlabs.image.WholeImageFilter;

public class DistanceFilter
extends WholeImageFilter {
    private double factor = 1.0;
    protected Colormap colormap;
    private boolean useAlpha = true;
    private static final int one = 41;
    private static final int sqrt2 = 58;
    private static final int sqrt5 = 92;

    public void setFactor(double d) {
        this.factor = d;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setUseAlpha(boolean bl) {
        this.useAlpha = bl;
    }

    public boolean getUseAlpha() {
        return this.useAlpha;
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        try {
            int n2 = this.originalSpace.width;
            int n3 = this.originalSpace.height;
            int[] nArray = new int[n2 * n3];
            this.convertToIntegers(this.inPixels, nArray, n2, n3);
            int n4 = this.distanceMap(nArray, n2, n3);
            this.convertToPixels(nArray, n2, n3, n4);
            this.consumer.setPixels(0, 0, n2, n3, this.defaultRGBModel, nArray, 0, n2);
            this.consumer.imageComplete(n);
            this.inPixels = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int distanceMap(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = n - 3;
        int n7 = n2 - 3;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n2) {
            n5 = 0;
            while (n5 < n) {
                n4 = n5 + n9 * n;
                if (nArray[n4] > 0 && (n3 = n5 < 2 || n5 > n6 || n9 < 2 || n9 > n7 ? this.setEdgeValue(n5, n9, nArray, n, n4, n6, n7) : this.setValue(nArray, n, n4)) > n8) {
                    n8 = n3;
                }
                ++n5;
            }
            ++n9;
        }
        n5 = n2 - 1;
        while (n5 >= 0) {
            n4 = n - 1;
            while (n4 >= 0) {
                int n10 = n4 + n5 * n;
                if (nArray[n10] > 0 && (n3 = n4 < 2 || n4 > n6 || n5 < 2 || n5 > n7 ? this.setEdgeValue(n4, n5, nArray, n, n10, n6, n7) : this.setValue(nArray, n, n10)) > n8) {
                    n8 = n3;
                }
                --n4;
            }
            --n5;
        }
        return n8;
    }

    private void convertToIntegers(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = n4 + n3 * n;
                int n6 = this.useAlpha ? nArray[n5] >> 24 & 0xFF : (PixelUtils.brightness(nArray[n5]) > 127 ? 255 : 0);
                nArray2[n5] = n6 * 41;
                ++n4;
            }
            ++n3;
        }
    }

    private void convertToPixels(int[] nArray, int n, int n2, int n3) {
        int n4 = 20;
        if (n3 == 0) {
            n3 = 1;
        }
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            while (n6 < n) {
                int n7 = n6 + n5 * n;
                if (this.colormap == null) {
                    int n8 = (int)(this.factor * (double)(nArray[n7] + n4) / 41.0);
                    if (n8 > 255) {
                        n8 = 255;
                    }
                    nArray[n7] = 0xFF000000 | n8 << 16 | n8 << 8 | n8;
                } else {
                    double d = this.factor * (double)(nArray[n7] + n4) / 41.0 / 255.0;
                    nArray[n7] = this.colormap.getColor(d);
                }
                ++n6;
            }
            ++n5;
        }
    }

    private int setEdgeValue(int n, int n2, int[] nArray, int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = n4 - n3 - n3 - 2;
        int n9 = n8 + n3;
        int n10 = n9 + n3;
        int n11 = n10 + n3;
        int n12 = n11 + n3;
        int n13 = nArray[n10 + 2];
        int n14 = n2 < 2 ? n13 + 41 : nArray[n9 + 2] + 41;
        n14 = n < 2 ? n13 + 41 : nArray[n10 + 1] + 41;
        if (n14 < (n7 = n14)) {
            n7 = n14;
        }
        if ((n14 = n > n5 ? n13 + 41 : nArray[n10 + 3] + 41) < n7) {
            n7 = n14;
        }
        if ((n14 = n2 > n6 ? n13 + 41 : nArray[n11 + 2] + 41) < n7) {
            n7 = n14;
        }
        if ((n14 = n < 2 || n2 < 2 ? n13 + 58 : nArray[n9 + 1] + 58) < n7) {
            n7 = n14;
        }
        if ((n14 = n > n5 || n2 < 2 ? n13 + 58 : nArray[n9 + 3] + 58) < n7) {
            n7 = n14;
        }
        if ((n14 = n < 2 || n2 > n6 ? n13 + 58 : nArray[n11 + 1] + 58) < n7) {
            n7 = n14;
        }
        if ((n14 = n > n5 || n2 > n6 ? n13 + 58 : nArray[n11 + 3] + 58) < n7) {
            n7 = n14;
        }
        if ((n14 = n < 2 || n2 < 2 ? n13 + 92 : nArray[n8 + 1] + 92) < n7) {
            n7 = n14;
        }
        if ((n14 = n > n5 || n2 < 2 ? n13 + 92 : nArray[n8 + 3] + 92) < n7) {
            n7 = n14;
        }
        if ((n14 = n > n5 || n2 < 2 ? n13 + 92 : nArray[n9 + 4] + 92) < n7) {
            n7 = n14;
        }
        if ((n14 = n > n5 || n2 > n6 ? n13 + 92 : nArray[n11 + 4] + 92) < n7) {
            n7 = n14;
        }
        if ((n14 = n > n5 || n2 > n6 ? n13 + 92 : nArray[n12 + 3] + 92) < n7) {
            n7 = n14;
        }
        if ((n14 = n < 2 || n2 > n6 ? n13 + 92 : nArray[n12 + 1] + 92) < n7) {
            n7 = n14;
        }
        if ((n14 = n < 2 || n2 > n6 ? n13 + 92 : nArray[n11] + 92) < n7) {
            n7 = n14;
        }
        if ((n14 = n < 2 || n2 < 2 ? n13 + 92 : nArray[n9] + 92) < n7) {
            n7 = n14;
        }
        nArray[n4] = n7;
        return nArray[n4];
    }

    private int setValue(int[] nArray, int n, int n2) {
        int n3 = n2 - n - n - 2;
        int n4 = n3 + n;
        int n5 = n4 + n;
        int n6 = n5 + n;
        int n7 = n6 + n;
        int n8 = nArray[n5 + 1] + 41;
        n8 = nArray[n4 + 2] + 41;
        int n9 = n8;
        if (n8 < n9) {
            n9 = n8;
        }
        if ((n8 = nArray[n5 + 3] + 41) < n9) {
            n9 = n8;
        }
        if ((n8 = nArray[n6 + 2] + 41) < n9) {
            n9 = n8;
        }
        if ((n8 = nArray[n4 + 1] + 58) < n9) {
            n9 = n8;
        }
        if ((n8 = nArray[n4 + 3] + 58) < n9) {
            n9 = n8;
        }
        if ((n8 = nArray[n6 + 1] + 58) < n9) {
            n9 = n8;
        }
        if ((n8 = nArray[n6 + 3] + 58) < n9) {
            n9 = n8;
        }
        if ((n8 = nArray[n3 + 1] + 92) < n9) {
            n9 = n8;
        }
        if ((n8 = nArray[n3 + 3] + 92) < n9) {
            n9 = n8;
        }
        if ((n8 = nArray[n4 + 4] + 92) < n9) {
            n9 = n8;
        }
        if ((n8 = nArray[n6 + 4] + 92) < n9) {
            n9 = n8;
        }
        if ((n8 = nArray[n7 + 3] + 92) < n9) {
            n9 = n8;
        }
        if ((n8 = nArray[n7 + 1] + 92) < n9) {
            n9 = n8;
        }
        if ((n8 = nArray[n6] + 92) < n9) {
            n9 = n8;
        }
        if ((n8 = nArray[n4] + 92) < n9) {
            n9 = n8;
        }
        nArray[n2] = n9;
        return nArray[n2];
    }

    public String toString() {
        return "Binary/Distance Map";
    }
}

