/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.io.Serializable;
import java.util.Date;
import java.util.Random;
import jj.play.ns.com.jhlabs.image.Colormap;
import jj.play.ns.com.jhlabs.image.LinearColormap;
import jj.play.ns.com.jhlabs.image.WholeImageFilter;

public class CraterFilter
extends WholeImageFilter
implements Serializable {
    static final long serialVersionUID = 6491871753122667752L;
    private Colormap colormap = new LinearColormap();
    private Random randomGenerator = new Random();
    private long seed = 567L;
    private int numCraters = 25000;
    private double depthPower = 1.0;
    private double depthBias = 0.707107;
    private double depthScaling = 1.0;
    private boolean spherical = false;

    public void setNumCraters(int n) {
        this.numCraters = n;
    }

    public int getNumCraters() {
        return this.numCraters;
    }

    public void setDepthPower(double d) {
        this.depthPower = d;
    }

    public double getDepthPower() {
        return this.depthPower;
    }

    public void setDepthBias(double d) {
        this.depthBias = d;
    }

    public double getDepthBias() {
        return this.depthBias;
    }

    public void setDepthScaling(double d) {
        this.depthScaling = d;
    }

    public double getDepthScaling() {
        return this.depthScaling;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setSpherical(boolean bl) {
        this.spherical = bl;
    }

    public boolean isSpherical() {
        return this.spherical;
    }

    public void randomize() {
        this.seed = new Date().getTime();
    }

    private double random(double d, double d2) {
        return d + (d2 - d) * this.randomGenerator.nextDouble();
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        try {
            int n2;
            int n3;
            int n4;
            int n5;
            double d;
            int n6;
            int n7;
            int n8 = this.originalSpace.width;
            int n9 = this.originalSpace.height;
            int[] nArray = new int[n8 * n9];
            this.randomGenerator.setSeed(this.seed);
            int n10 = 0;
            int n11 = 0;
            while (n11 < n9) {
                n7 = 0;
                while (n7 < n8) {
                    nArray[n10++] = Short.MAX_VALUE;
                    ++n7;
                }
                ++n11;
            }
            n10 = 0;
            while (n10 < this.numCraters) {
                int n12;
                int n13 = (int)this.random(0.0, n8 - 1);
                int n14 = (int)this.random(0.0, n9 - 1);
                int n15 = 0;
                n6 = 0;
                d = Math.sqrt(1.0 / (Math.PI * (1.0 - this.random(0.0, 0.9999))));
                if (d < 3.0) {
                    n11 = Math.max(0, n14 - 1);
                    while (n11 <= Math.min(n9 - 1, n14 + 1)) {
                        n5 = Math.max(0, n13 - 1);
                        n12 = n11 * n8 + n5;
                        n7 = n5;
                        while (n7 <= Math.min(n8 - 1, n13 + 1)) {
                            n15 += nArray[n12++];
                            ++n6;
                            ++n7;
                        }
                        ++n11;
                    }
                    n4 = n15 / n6;
                    n7 = d >= 1.0 ? (this.randomGenerator.nextInt() >> 8 & 3) - 1 : 0;
                    n7 = (int)((double)n7 * this.depthScaling);
                    nArray[n8 * n14 + n13] = n4 + n7;
                } else {
                    n3 = (int)Math.max(2.0, d / 3.0);
                    n2 = (int)Math.max(2.0, d / 3.0);
                    n11 = Math.max(0, n14 - n2);
                    while (n11 <= Math.min(n9 - 1, n14 + n2)) {
                        n5 = Math.max(0, n13 - n3);
                        n12 = n11 * n8 + n5;
                        n7 = n5;
                        while (n7 <= Math.min(n8 - 1, n13 + n3)) {
                            n15 += nArray[n12++];
                            ++n6;
                            ++n7;
                        }
                        ++n11;
                    }
                    n4 = n15 / n6;
                    n2 = (int)Math.max(2.0, d);
                    d = n2;
                    n3 = (int)Math.max(2.0, d);
                    n11 = Math.max(0, n14 - n2);
                    while (n11 <= Math.min(n9 - 1, n14 + n2)) {
                        n5 = Math.max(0, n13 - n3);
                        n12 = n11 * n8 + n5;
                        double d2 = (double)(n14 - n11) / (double)n2;
                        double d3 = d2 * d2;
                        n7 = n5;
                        while (n7 <= Math.min(n8 - 1, n13 + n3)) {
                            double d4 = (double)(n13 - n7) / (double)n3;
                            double d5 = d4 * d4 + d3;
                            double d6 = d5 * 2.25;
                            double d7 = this.depthBias - Math.sqrt(Math.abs(1.0 - d6));
                            double d8 = Math.max(d6 > 1.0 ? 0.0 : -10.0, d7);
                            if (d2 == 0.0 && d4 == 0.0 && (int)(d8 *= Math.pow(d, this.depthPower)) == 0) {
                                d8 = d8 < 0.0 ? -1 : 1;
                            }
                            double d9 = 0.9;
                            double d10 = (1.0 / (1.0 - Math.min(d9, d5)) / (1.0 / (1.0 - d9)) - (1.0 - d9)) / d9;
                            double d11 = 1.0 - d10;
                            int n16 = (int)(((double)n4 + (d8 *= this.depthScaling)) * d11 + ((double)nArray[n12] + d8) * d10);
                            n16 = Math.max(1000, Math.min(64000, n16));
                            nArray[n12++] = n16;
                            ++n7;
                        }
                        ++n11;
                    }
                }
                ++n10;
            }
            d = 0.5;
            double d12 = 1.0;
            n3 = -52;
            n2 = 52;
            n10 = Math.max(n2 - n3 + 1, 1);
            double[] dArray = new double[n10];
            n10 = n3;
            while (n10 <= n2) {
                dArray[n10 - n3] = n10 > 0 ? 0.5 + 0.5 * Math.pow(Math.sin(1.5707963267948966 * (double)n10 / (double)n2), d12 * d) : 0.5 - 127.0 * Math.pow(Math.sin(1.5707963267948966 * (double)n10 / (double)n3), d12 * d);
                ++n10;
            }
            if (this.colormap != null) {
                n4 = 0;
                n11 = 0;
                while (n11 < n9) {
                    n6 = nArray[n4];
                    n7 = 0;
                    while (n7 < n8) {
                        n5 = nArray[n4];
                        int n17 = n5 - n6;
                        n17 = Math.min(Math.max(n3, n17), n2);
                        nArray[n4] = this.colormap.getColor(dArray[n17 - n3]);
                        n6 = n5;
                        ++n4;
                        ++n7;
                    }
                    ++n11;
                }
            }
            this.consumer.setPixels(0, 0, n8, n9, this.defaultRGBModel, nArray, 0, n8);
            this.consumer.imageComplete(n);
            this.inPixels = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String toString() {
        return "Texture/Crater...";
    }
}

