/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.bcel.analyser;

import java.util.ArrayList;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.Frame;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.UninitializedObjectType;

public class OperandStack {
    private ArrayList<Type> stack = new ArrayList();
    private int maxStack;

    public OperandStack(int maxStack) {
        this.maxStack = maxStack;
    }

    public OperandStack(int maxStack, ObjectType obj) {
        this.maxStack = maxStack;
        this.push((Type)obj);
    }

    protected Object clone() {
        ArrayList cloned;
        OperandStack newstack = new OperandStack(this.maxStack);
        newstack.stack = cloned = (ArrayList)this.stack.clone();
        return newstack;
    }

    public void clear() {
        this.stack = new ArrayList();
    }

    public boolean equals(Object o) {
        if (!(o instanceof OperandStack)) {
            return false;
        }
        OperandStack s = (OperandStack)o;
        return this.stack.equals(s.stack);
    }

    public OperandStack getClone() {
        return (OperandStack)this.clone();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public int maxStack() {
        return this.maxStack;
    }

    public Type peek() {
        return this.peek(0);
    }

    public Type peek(int i) {
        return this.stack.get(this.size() - i - 1);
    }

    public Type pop() {
        Type e = this.stack.remove(this.size() - 1);
        return e;
    }

    public Type pop(int i) {
        for (int j = 0; j < i; ++j) {
            this.pop();
        }
        return null;
    }

    public void push(Type type) {
        if (type == null) {
            throw new AssertionViolatedException("Cannot push NULL onto OperandStack.");
        }
        if (type == Type.BOOLEAN || type == Type.CHAR || type == Type.BYTE || type == Type.SHORT) {
            throw new AssertionViolatedException("The OperandStack does not know about '" + type + "'; use Type.INT instead.");
        }
        if (this.slotsUsed() >= this.maxStack) {
            throw new AssertionViolatedException("OperandStack too small, should have thrown proper Exception elsewhere. Stack: " + this);
        }
        this.stack.add(type);
    }

    public int size() {
        return this.stack.size();
    }

    public int slotsUsed() {
        int slots = 0;
        for (int i = 0; i < this.stack.size(); ++i) {
            slots += this.peek(i).getSize();
        }
        return slots;
    }

    public String toString() {
        String s = "Slots used: " + this.slotsUsed() + " MaxStack: " + this.maxStack + ".\n";
        for (int i = 0; i < this.size(); ++i) {
            s = s + this.peek(i) + " (Size: " + this.peek(i).getSize() + ")\n";
        }
        return s;
    }

    public void merge(OperandStack s) {
        if (this.slotsUsed() != s.slotsUsed() || this.size() != s.size()) {
            throw new StructuralCodeConstraintException("Cannot merge stacks of different size:\nOperandStack A:\n" + this + "\nOperandStack B:\n" + s);
        }
        for (int i = 0; i < this.size(); ++i) {
            this.stack.set(i, Frame.merge(this.stack.get(i), s.stack.get(i), true));
        }
    }

    public void initializeObject(UninitializedObjectType u) {
        for (int i = 0; i < this.stack.size(); ++i) {
            if (this.stack.get(i) != u) continue;
            this.stack.set(i, (Type)u.getInitialized());
        }
    }
}

