/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.io.Serializable;
import jj.play.ns.com.jhlabs.image.ArrayColormap;
import jj.play.ns.com.jhlabs.image.ImageMath;
import jj.play.ns.com.jhlabs.image.PixelUtils;

public class SplineColormap
extends ArrayColormap
implements Serializable {
    public int numKnots = 4;
    public int[] xKnots;
    public int[] yKnots;

    public SplineColormap() {
        int[] nArray = new int[4];
        nArray[2] = 255;
        nArray[3] = 255;
        this.xKnots = nArray;
        this.yKnots = new int[]{-16777216, -16777216, -1, -1};
        this.rebuildGradient();
    }

    public SplineColormap(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[4];
        nArray3[2] = 255;
        nArray3[3] = 255;
        this.xKnots = nArray3;
        this.yKnots = new int[]{-16777216, -16777216, -1, -1};
        this.xKnots = nArray;
        this.yKnots = nArray2;
        this.numKnots = nArray.length;
        this.rebuildGradient();
    }

    public int getKnot(int n) {
        return this.yKnots[n];
    }

    public void setKnot(int n, int n2) {
        this.yKnots[n] = n2;
        this.rebuildGradient();
    }

    public void addKnot(int n, int n2) {
        int[] nArray = new int[this.numKnots + 1];
        int[] nArray2 = new int[this.numKnots + 1];
        System.arraycopy(this.xKnots, 0, nArray, 0, this.numKnots);
        System.arraycopy(this.yKnots, 0, nArray2, 0, this.numKnots);
        this.xKnots = nArray;
        this.yKnots = nArray2;
        this.xKnots[this.numKnots] = n;
        this.yKnots[this.numKnots] = n2;
        ++this.numKnots;
        this.sortKnots();
        this.rebuildGradient();
    }

    public void removeKnot(int n) {
        if (this.numKnots <= 4) {
            return;
        }
        if (n < this.numKnots - 1) {
            System.arraycopy(this.xKnots, n + 1, this.xKnots, n, this.numKnots - n - 1);
            System.arraycopy(this.yKnots, n + 1, this.yKnots, n, this.numKnots - n - 1);
        }
        --this.numKnots;
        this.rebuildGradient();
    }

    public void setKnotPosition(int n, int n2) {
        this.xKnots[n] = PixelUtils.clamp(n2);
        this.sortKnots();
        this.rebuildGradient();
    }

    private void rebuildGradient() {
        this.xKnots[0] = -1;
        this.xKnots[this.numKnots - 1] = 256;
        this.yKnots[0] = this.yKnots[1];
        this.yKnots[this.numKnots - 1] = this.yKnots[this.numKnots - 2];
        int n = 0;
        while (n < 256) {
            this.map[n] = ImageMath.colorSpline(n, this.numKnots, this.xKnots, this.yKnots);
            ++n;
        }
    }

    private void sortKnots() {
        int n = 1;
        while (n < this.numKnots) {
            int n2 = 1;
            while (n2 < n) {
                if (this.xKnots[n] < this.xKnots[n2]) {
                    int n3 = this.xKnots[n];
                    this.xKnots[n] = this.xKnots[n2];
                    this.xKnots[n2] = n3;
                    n3 = this.yKnots[n];
                    this.yKnots[n] = this.yKnots[n2];
                    this.yKnots[n2] = n3;
                }
                ++n2;
            }
            ++n;
        }
    }
}

