/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.io.Serializable;
import jj.play.ns.com.jhlabs.image.OctTreeQuantizer;
import jj.play.ns.com.jhlabs.image.PixelUtils;
import jj.play.ns.com.jhlabs.image.WholeImageFilter;

public class QuantizeFilter
extends WholeImageFilter
implements Serializable {
    protected static final int[] matrix;
    private int sum = 16;
    private boolean dither;
    private int numColors = 256;
    private boolean serpentine = true;

    static {
        int[] nArray = new int[9];
        nArray[5] = 7;
        nArray[6] = 3;
        nArray[7] = 5;
        nArray[8] = 1;
        matrix = nArray;
    }

    public void setNumColors(int n) {
        this.numColors = Math.min(Math.max(n, 8), 256);
    }

    public int getNumColors() {
        return this.numColors;
    }

    public void setDither(boolean bl) {
        this.dither = bl;
    }

    public boolean getDither() {
        return this.dither;
    }

    public void setSerpentine(boolean bl) {
        this.serpentine = bl;
    }

    public boolean getSerpentine() {
        return this.serpentine;
    }

    public void quantize(int[] nArray, int[] nArray2, int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4 = n * n2;
        OctTreeQuantizer octTreeQuantizer = new OctTreeQuantizer();
        octTreeQuantizer.setup(n3);
        octTreeQuantizer.addPixels(nArray, 0, n4);
        int[] nArray3 = octTreeQuantizer.buildColorTable();
        if (!bl) {
            int n5 = 0;
            while (n5 < n4) {
                nArray2[n5] = nArray3[octTreeQuantizer.getIndexForColor(nArray[n5])];
                ++n5;
            }
        } else {
            int n6 = 0;
            int n7 = 0;
            while (n7 < n2) {
                int n8;
                boolean bl3;
                boolean bl4 = bl3 = bl2 && (n7 & 1) == 1;
                if (bl3) {
                    n6 = n7 * n + n - 1;
                    n8 = -1;
                } else {
                    n6 = n7 * n;
                    n8 = 1;
                }
                int n9 = 0;
                while (n9 < n) {
                    int n10;
                    int n11 = nArray[n6];
                    nArray2[n6] = n10 = nArray3[octTreeQuantizer.getIndexForColor(n11)];
                    int n12 = n11 >> 16 & 0xFF;
                    int n13 = n11 >> 8 & 0xFF;
                    int n14 = n11 & 0xFF;
                    int n15 = n10 >> 16 & 0xFF;
                    int n16 = n10 >> 8 & 0xFF;
                    int n17 = n10 & 0xFF;
                    int n18 = n12 - n15;
                    int n19 = n13 - n16;
                    int n20 = n14 - n17;
                    int n21 = -1;
                    while (n21 <= 1) {
                        int n22 = n21 + n7;
                        if (n22 >= 0 && n22 < n2) {
                            int n23 = -1;
                            while (n23 <= 1) {
                                int n24;
                                int n25 = n23 + n9;
                                if (n25 >= 0 && n25 < n && (n24 = bl3 ? matrix[(n21 + 1) * 3 - n23 + 1] : matrix[(n21 + 1) * 3 + n23 + 1]) != 0) {
                                    int n26 = bl3 ? n6 - n23 : n6 + n23;
                                    n11 = nArray[n26];
                                    n12 = n11 >> 16 & 0xFF;
                                    n13 = n11 >> 8 & 0xFF;
                                    n14 = n11 & 0xFF;
                                    nArray[n26] = PixelUtils.clamp(n12 += n18 * n24 / this.sum) << 16 | PixelUtils.clamp(n13 += n19 * n24 / this.sum) << 8 | PixelUtils.clamp(n14 += n20 * n24 / this.sum);
                                }
                                ++n23;
                            }
                        }
                        ++n21;
                    }
                    n6 += n8;
                    ++n9;
                }
                ++n7;
            }
        }
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int n2 = this.originalSpace.width;
        int n3 = this.originalSpace.height;
        int[] nArray = new int[n2 * n3];
        this.quantize(this.inPixels, nArray, n2, n3, this.numColors, this.dither, this.serpentine);
        this.consumer.setPixels(0, 0, n2, n3, this.defaultRGBModel, nArray, 0, n2);
        this.consumer.imageComplete(n);
    }

    public String toString() {
        return "Colors/Quantize...";
    }
}

