/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import jj.play.ns.com.jhlabs.image.PixelUtils;
import jj.play.ns.com.jhlabs.image.WholeImageFilter;

public class MotionBlurFilter
extends WholeImageFilter {
    public static final int LINEAR = 0;
    public static final int RADIAL = 1;
    public static final int ZOOM = 2;
    private double angle = 0.0;
    private double falloff = 1.0;
    private double distance = 1.0;
    private int repetitions = 4;
    private int type = 0;

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setAngle(double d) {
        this.angle = d;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setDistance(double d) {
        this.distance = d;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setRepetitions(int n) {
        this.repetitions = n;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int n2 = this.originalSpace.width;
        int n3 = this.originalSpace.height;
        int n4 = 0;
        int[] nArray = new int[n2 * n3];
        double d = Math.sin(this.angle);
        double d2 = Math.cos(this.angle);
        int n5 = n2 / 2;
        int n6 = n3 / 2;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = 0;
            while (n8 < n2) {
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                while (n13 < this.repetitions) {
                    int n14 = n8;
                    int n15 = n7;
                    if (n13 != 0) {
                        switch (this.type) {
                            default: {
                                n14 = (int)((double)n8 + (double)n13 * this.distance * d);
                                n15 = (int)((double)n7 + (double)n13 * this.distance * d2);
                                break;
                            }
                            case 1: {
                                double d3 = n8 - n5;
                                double d4 = n7 - n6;
                                double d5 = Math.sqrt(d3 * d3 + d4 * d4);
                                double d6 = Math.atan2(d4, d3);
                                n14 = (int)((double)n5 + d5 * Math.cos(d6 += this.distance * (double)(n13 - this.repetitions / 2) / Math.PI / 10.0));
                                n15 = (int)((double)n6 + d5 * Math.sin(d6));
                                break;
                            }
                            case 2: {
                                double d3 = n8 - n5;
                                double d4 = n7 - n6;
                                n14 = (int)((double)n5 + (1.0 - (double)n13 * this.distance / 100.0) * d3);
                                n15 = (int)((double)n6 + (1.0 - (double)n13 * this.distance / 100.0) * d4);
                            }
                        }
                        if (n14 < 0 || n14 >= n2 || n15 < 0 || n15 >= n3) break;
                    }
                    ++n12;
                    int n16 = this.inPixels[n15 * n2 + n14];
                    n9 += n16 >> 16 & 0xFF;
                    n10 += n16 >> 8 & 0xFF;
                    n11 += n16 & 0xFF;
                    ++n13;
                }
                if (n12 == 0) {
                    nArray[n4] = this.inPixels[n4];
                } else {
                    n9 = PixelUtils.clamp(n9 / n12);
                    n10 = PixelUtils.clamp(n10 / n12);
                    n11 = PixelUtils.clamp(n11 / n12);
                    nArray[n4] = 0xFF000000 | n9 << 16 | n10 << 8 | n11;
                }
                ++n4;
                ++n8;
            }
            ++n7;
        }
        this.consumer.setPixels(0, 0, n2, n3, this.defaultRGBModel, nArray, 0, n2);
        this.consumer.imageComplete(n);
        this.inPixels = null;
    }

    public String toString() {
        return "Blur/Motion Blur...";
    }
}

